"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardTabTitleSetter = void 0;
var _react = require("react");
var _common = require("@kbn/embeddable-plugin/common");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_app_strings = require("../_dashboard_app_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardTabTitleSetter = ({
  dashboardContainer
}) => {
  const {
    chrome: {
      docTitle: chromeDocTitle
    }
  } = _plugin_services.pluginServices.getServices();
  const title = dashboardContainer.select(state => state.explicitInput.title);
  const lastSavedId = dashboardContainer.select(state => state.componentState.lastSavedId);

  /**
   * Set chrome tab title when dashboard's title changes
   */
  (0, _react.useEffect)(() => {
    /** We do not want the tab title to include the "Editing" prefix, so always send in view mode */
    chromeDocTitle.change((0, _dashboard_app_strings.getDashboardTitle)(title, _common.ViewMode.VIEW, !lastSavedId));
  }, [title, chromeDocTitle, lastSavedId]);
  return null;
};
exports.DashboardTabTitleSetter = DashboardTabTitleSetter;