"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToLibraryAction = exports.ACTION_ADD_TO_LIBRARY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _dashboard_container = require("../dashboard_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const ACTION_ADD_TO_LIBRARY = 'saveToLibrary';
exports.ACTION_ADD_TO_LIBRARY = ACTION_ADD_TO_LIBRARY;
class AddToLibraryAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "id", ACTION_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "order", 15);
    (0, _defineProperty2.default)(this, "applicationCapabilities", void 0);
    (0, _defineProperty2.default)(this, "toastsService", void 0);
    ({
      application: {
        capabilities: this.applicationCapabilities
      },
      notifications: {
        toasts: this.toastsService
      }
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return 'folderCheck';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$getInput;
    // TODO: Fix this, potentially by adding a 'canSave' function to embeddable interface
    const {
      maps,
      visualize
    } = this.applicationCapabilities;
    const canSave = embeddable.type === 'map' ? maps.save : visualize.save;
    const {
      isOfAggregateQueryType
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
    const query = (0, _public.isFilterableEmbeddable)(embeddable) && (await embeddable.getQuery());
    // Textbased panels (i.e. ES|QL, SQL) should not save to library
    const isTextBasedEmbeddable = isOfAggregateQueryType(query);
    return Boolean(canSave && !(0, _public.isErrorEmbeddable)(embeddable) && ((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.viewMode) !== _public.ViewMode.VIEW && embeddable.getRoot() && embeddable.getRoot().isContainer && embeddable.getRoot().type === _dashboard_container.DASHBOARD_CONTAINER_TYPE && (0, _public.isReferenceOrValueEmbeddable)(embeddable) && !embeddable.inputIsRefType(embeddable.getInput()) && !isTextBasedEmbeddable);
  }
  async execute({
    embeddable
  }) {
    if (!(0, _public.isReferenceOrValueEmbeddable)(embeddable)) {
      throw new _public2.IncompatibleActionError();
    }
    const newInput = await embeddable.getInputAsRefType();
    embeddable.updateInput(newInput);
    const dashboard = embeddable.getRoot();
    const panelToReplace = dashboard.getInput().panels[embeddable.id];
    if (!panelToReplace) {
      throw new _public.PanelNotFoundError();
    }
    const newPanel = {
      type: embeddable.type,
      explicitInput: {
        ...newInput
      }
    };
    const replacedPanelId = await dashboard.replacePanel(panelToReplace, newPanel, true);
    const title = _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getSuccessMessage(embeddable.getTitle() ? `'${embeddable.getTitle()}'` : '');
    if (dashboard.getExpandedPanelId() !== undefined) {
      dashboard.setExpandedPanelId(replacedPanelId);
    }
    this.toastsService.addSuccess({
      title,
      'data-test-subj': 'addPanelToLibrarySuccess'
    });
  }
}
exports.AddToLibraryAction = AddToLibraryAction;