"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardAttributesSchema = _configSchema.schema.object({
  // General
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string({
    defaultValue: ''
  }),
  // Search
  kibanaSavedObjectMeta: _configSchema.schema.object({
    searchSourceJSON: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  // Time
  timeRestore: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  timeFrom: _configSchema.schema.maybe(_configSchema.schema.string()),
  timeTo: _configSchema.schema.maybe(_configSchema.schema.string()),
  refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
    pause: _configSchema.schema.boolean(),
    value: _configSchema.schema.number(),
    display: _configSchema.schema.maybe(_configSchema.schema.string()),
    section: _configSchema.schema.maybe(_configSchema.schema.number())
  })),
  // Dashboard Content
  controlGroupInput: _configSchema.schema.maybe(_configSchema.schema.object({
    panelsJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
    controlStyle: _configSchema.schema.maybe(_configSchema.schema.string()),
    chainingSystem: _configSchema.schema.maybe(_configSchema.schema.string()),
    ignoreParentSettingsJSON: _configSchema.schema.maybe(_configSchema.schema.string())
  })),
  panelsJSON: _configSchema.schema.string({
    defaultValue: '[]'
  }),
  optionsJSON: _configSchema.schema.string({
    defaultValue: '{}'
  }),
  // Legacy
  hits: _configSchema.schema.maybe(_configSchema.schema.number()),
  version: _configSchema.schema.maybe(_configSchema.schema.number())
}, {
  unknowns: 'forbid'
});
const dashboardSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(dashboardAttributesSchema);
const searchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const createOptionsSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.id),
  overwrite: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.overwrite),
  references: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.references)
});

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(dashboardSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: createOptionsSchema
      },
      data: {
        schema: dashboardAttributesSchema
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(dashboardSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      options: {
        schema: createOptionsSchema // same schema as "create"
      },

      data: {
        schema: dashboardAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: searchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: dashboardSavedObjectSchema
      }
    }
  }
};
exports.serviceDefinition = serviceDefinition;