"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_FLYOUT_ADD_DRILLDOWN = exports.FlyoutCreateDrilldownAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/embeddable-enhanced-plugin/public");
var _drilldown_shared = require("../drilldown_shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_FLYOUT_ADD_DRILLDOWN = 'OPEN_FLYOUT_ADD_DRILLDOWN';
exports.OPEN_FLYOUT_ADD_DRILLDOWN = OPEN_FLYOUT_ADD_DRILLDOWN;
class FlyoutCreateDrilldownAction {
  constructor(params) {
    (0, _defineProperty2.default)(this, "type", OPEN_FLYOUT_ADD_DRILLDOWN);
    (0, _defineProperty2.default)(this, "id", OPEN_FLYOUT_ADD_DRILLDOWN);
    (0, _defineProperty2.default)(this, "order", 12);
    (0, _defineProperty2.default)(this, "grouping", _public3.embeddableEnhancedDrilldownGrouping);
    this.params = params;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.dashboard.FlyoutCreateDrilldownAction.displayName', {
      defaultMessage: 'Create drilldown'
    });
  }
  getIconType() {
    return 'plusInCircle';
  }
  isEmbeddableCompatible(context) {
    if (!(0, _public3.isEnhancedEmbeddable)(context.embeddable)) return false;
    if (context.embeddable.getRoot().type !== 'dashboard') return false;
    const supportedTriggers = [_public2.CONTEXT_MENU_TRIGGER, ...(context.embeddable.supportedTriggers() || [])];

    /**
     * Check if there is an intersection between all registered drilldowns possible triggers that they could be attached to
     * and triggers that current embeddable supports
     */
    const allPossibleTriggers = this.params.start().plugins.uiActionsEnhanced.getActionFactories().map(factory => factory.isCompatibleLicense() ? factory.supportedTriggers() : []).reduce((res, next) => res.concat(next), []);
    return (0, _drilldown_shared.ensureNestedTriggers)(supportedTriggers).some(trigger => allPossibleTriggers.includes(trigger));
  }
  async isCompatible(context) {
    const isEditMode = context.embeddable.getInput().viewMode === 'edit';
    return isEditMode && this.isEmbeddableCompatible(context);
  }
  async execute(context) {
    const {
      core,
      plugins
    } = this.params.start();
    const {
      embeddable
    } = context;
    if (!(0, _public3.isEnhancedEmbeddable)(embeddable)) {
      throw new Error('Need embeddable to be EnhancedEmbeddable to execute FlyoutCreateDrilldownAction.');
    }
    const templates = (0, _drilldown_shared.createDrilldownTemplatesFromSiblings)(embeddable);
    const closed$ = new _rxjs.Subject();
    const close = () => {
      closed$.next(true);
      handle.close();
    };
    const closeFlyout = () => {
      close();
    };
    const triggers = [...(0, _drilldown_shared.ensureNestedTriggers)(embeddable.supportedTriggers()), _public2.CONTEXT_MENU_TRIGGER];
    const handle = core.overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(plugins.uiActionsEnhanced.DrilldownManager, {
      closeAfterCreate: true,
      initialRoute: '/new',
      dynamicActionManager: embeddable.enhancements.dynamicActions,
      triggers: triggers,
      placeContext: {
        embeddable
      },
      templates: templates,
      onClose: close
    }), {
      theme$: core.theme.theme$
    }), {
      ownFocus: true,
      'data-test-subj': 'createDrilldownFlyout'
    });

    // Close flyout on application change.
    core.application.currentAppId$.pipe((0, _operators.takeUntil)(closed$), (0, _operators.skip)(1), (0, _operators.take)(1)).subscribe(closeFlyout);

    // Close flyout on dashboard switch to "view" mode or on embeddable destroy.
    embeddable.getInput$().pipe((0, _operators.takeUntil)(closed$), (0, _operators.map)(input => input.viewMode), (0, _operators.distinctUntilChanged)(), (0, _operators.filter)(mode => mode !== _public2.ViewMode.EDIT), (0, _operators.take)(1)).subscribe({
      next: closeFlyout,
      complete: closeFlyout
    });
  }
}
exports.FlyoutCreateDrilldownAction = FlyoutCreateDrilldownAction;