"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDrilldownTemplatesFromSiblings = void 0;
exports.ensureNestedTriggers = ensureNestedTriggers;
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/embeddable-enhanced-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * We know that VALUE_CLICK_TRIGGER and SELECT_RANGE_TRIGGER are also triggering APPLY_FILTER_TRIGGER.
 * This function appends APPLY_FILTER_TRIGGER to the list of triggers if either VALUE_CLICK_TRIGGER
 * or SELECT_RANGE_TRIGGER was executed.
 *
 * TODO: this probably should be part of uiActions infrastructure,
 * but dynamic implementation of nested trigger doesn't allow to statically express such relations
 *
 * @param triggers
 */
function ensureNestedTriggers(triggers) {
  if (!triggers.includes(_public.APPLY_FILTER_TRIGGER) && (triggers.includes(_public2.VALUE_CLICK_TRIGGER) || triggers.includes(_public2.SELECT_RANGE_TRIGGER))) {
    return [...triggers, _public.APPLY_FILTER_TRIGGER];
  }
  return triggers;
}
const isEmbeddableContainer = x => x instanceof _public2.Container;

/**
 * Given a dashboard panel embeddable, it will find the parent (dashboard
 * container embeddable), then iterate through all the dashboard panels and
 * generate DrilldownTemplate for each existing drilldown.
 */
const createDrilldownTemplatesFromSiblings = embeddable => {
  const templates = [];
  const embeddableId = embeddable.id;
  const container = embeddable.getRoot();
  if (!container) return templates;
  if (!isEmbeddableContainer(container)) return templates;
  const childrenIds = container.getChildIds();
  for (const childId of childrenIds) {
    const child = container.getChild(childId);
    if (child.id === embeddableId) continue;
    if (!(0, _public3.isEnhancedEmbeddable)(child)) continue;
    const events = child.enhancements.dynamicActions.state.get().events;
    for (const event of events) {
      const template = {
        id: event.eventId,
        name: event.action.name,
        icon: 'dashboardApp',
        description: child.getTitle() || child.id,
        config: event.action.config,
        factoryId: event.action.factoryId,
        triggers: event.triggers
      };
      templates.push(template);
    }
  }
  return templates;
};
exports.createDrilldownTemplatesFromSiblings = createDrilldownTemplatesFromSiblings;