"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchDotnetClientReadme = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _dotnet = _interopRequireDefault(require("../../../assets/language_clients/dotnet.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// eslint-disable-next-line @kbn/eslint/module_migration

const CenterColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 740px;
`;
const FixedHeader = _styledComponents.default.div`
  width: 100%;
  height: 196px;
  border-bottom: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
`;
const IconPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  padding: ${props => props.theme.eui.euiSizeXL};
  width: ${props => parseFloat(props.theme.eui.euiSize) * 6 + parseFloat(props.theme.eui.euiSizeXL) * 2}px;
  svg,
  img {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    width: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
  }
  .euiFlexItem {
    height: ${props => parseFloat(props.theme.eui.euiSize) * 6}px;
    justify-content: center;
  }
`;
const TopFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  max-width: 1150px;
  margin-left: auto;
  margin-right: auto;
  padding: calc(${_uiTheme.euiThemeVars.euiSizeXL} * 2) ${_uiTheme.euiThemeVars.euiSizeM} 0 ${_uiTheme.euiThemeVars.euiSizeM};
`;
const ElasticsearchDotnetClientReadme = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FixedHeader, null, /*#__PURE__*/_react.default.createElement(TopFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(IconPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "fullWidth",
    src: _dotnet.default,
    alt: "icon"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.DotnetElasticsearch.readme.title",
    defaultMessage: "Elasticsearch .NET Client"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(CenterColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "customIntegrations.languageClients.DotnetElasticsearch.readme.intro",
      defaultMessage: "Getting started with the Elasticsearch .NET Client requires a few steps."
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.DotnetElasticsearch.readme.install",
    defaultMessage: "Install the Elasticsearch .NET Client"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.DotnetElasticsearch.readme.sdk",
    defaultMessage: "For SDK style projects, you can install the Elasticsearch client by running the following .NET CLI command in your terminal:"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "shell",
    isCopyable: true
  }, `$ redotnet add package Elastic.Clients.Elasticsearch --prerelease`), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.DotnetElasticsearch.readme.manually",
    defaultMessage: "Or, you can manually add a package reference inside your project file:"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: ".dotnet",
    isCopyable: true
  }, `<PackageReference Include="Elastic.Clients.Elasticsearch" Version="8.0.0-alpha.5" />`)), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.DotnetElasticsearch.readme.connecting",
    defaultMessage: "Connecting to Elastic cloud"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "customIntegrations.languageClients.DotnetElasticsearch.readme.connectingText",
    defaultMessage: "You can connect to Elastic Cloud using an {api_key} and a {cloud_id}:",
    values: {
      api_key: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "API key"),
      cloud_id: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "Cloud ID")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    language: "dotnet"
  }, `
// CLOUD_ID found in the 'Manage this deployment' page
// API_KEY found in the 'Management' page under the section 'Security'

using Elastic.Clients.Elasticsearch;
using Elastic.Transport;

var client = new ElasticsearchClient("<CLOUD_ID>", new ApiKey("<API_KEY>"));

          `)))))));
};
exports.ElasticsearchDotnetClientReadme = ElasticsearchDotnetClientReadme;