"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isApiAuthorized = exports.getStatsState = exports.getSelectedFollowerIndexId = exports.getSelectedFollowerIndex = exports.getSelectedAutoFollowPatternId = exports.getSelectedAutoFollowPattern = exports.getListFollowerIndices = exports.getListAutoFollowPatterns = exports.getFollowerIndices = exports.getFollowerIndexState = exports.getAutoFollowStats = exports.getAutoFollowPatterns = exports.getAutoFollowPatternState = exports.getApiStatus = exports.getApiState = exports.getApiError = void 0;
var _reselect = require("reselect");
var _utils = require("../../services/utils");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Api
const getApiState = state => state.api;
exports.getApiState = getApiState;
const getApiStatus = scope => (0, _reselect.createSelector)(getApiState, apiState => apiState.status[scope] || _constants.API_STATUS.IDLE);
exports.getApiStatus = getApiStatus;
const getApiError = scope => (0, _reselect.createSelector)(getApiState, apiState => apiState.error[scope]);
exports.getApiError = getApiError;
const isApiAuthorized = scope => (0, _reselect.createSelector)(getApiError(scope), error => {
  if (!error) {
    return true;
  }
  return error.status !== 403;
});

// Stats
exports.isApiAuthorized = isApiAuthorized;
const getStatsState = state => state.stats;
exports.getStatsState = getStatsState;
const getAutoFollowStats = (0, _reselect.createSelector)(getStatsState, statsState => statsState.autoFollow);

// Auto-follow pattern
exports.getAutoFollowStats = getAutoFollowStats;
const getAutoFollowPatternState = state => state.autoFollowPattern;
exports.getAutoFollowPatternState = getAutoFollowPatternState;
const getAutoFollowPatterns = (0, _reselect.createSelector)(getAutoFollowPatternState, autoFollowPatternsState => autoFollowPatternsState.byId);
exports.getAutoFollowPatterns = getAutoFollowPatterns;
const getSelectedAutoFollowPatternId = (view = 'detail') => (0, _reselect.createSelector)(getAutoFollowPatternState, autoFollowPatternsState => view === 'detail' ? autoFollowPatternsState.selectedDetailId : autoFollowPatternsState.selectedEditId);
exports.getSelectedAutoFollowPatternId = getSelectedAutoFollowPatternId;
const getSelectedAutoFollowPattern = (view = 'detail') => (0, _reselect.createSelector)(getAutoFollowPatternState, getAutoFollowStats, (autoFollowPatternsState, autoFollowStatsState) => {
  const propId = view === 'detail' ? 'selectedDetailId' : 'selectedEditId';
  if (!autoFollowPatternsState[propId]) {
    return null;
  }
  const id = autoFollowPatternsState[propId];
  const autoFollowPattern = autoFollowPatternsState.byId[id];

  // Check if any error and merge them on the auto-follow pattern
  const errors = autoFollowStatsState && autoFollowStatsState.recentAutoFollowErrors[id] || [];
  return autoFollowPattern ? {
    ...autoFollowPattern,
    errors
  } : null;
});
exports.getSelectedAutoFollowPattern = getSelectedAutoFollowPattern;
const getListAutoFollowPatterns = (0, _reselect.createSelector)(getAutoFollowPatterns, autoFollowPatterns => (0, _utils.objectToArray)(autoFollowPatterns));

// Follower index
exports.getListAutoFollowPatterns = getListAutoFollowPatterns;
const getFollowerIndexState = state => state.followerIndex;
exports.getFollowerIndexState = getFollowerIndexState;
const getFollowerIndices = (0, _reselect.createSelector)(getFollowerIndexState, followerIndexState => followerIndexState.byId);
exports.getFollowerIndices = getFollowerIndices;
const getSelectedFollowerIndexId = (view = 'detail') => (0, _reselect.createSelector)(getFollowerIndexState, followerIndexState => view === 'detail' ? followerIndexState.selectedDetailId : followerIndexState.selectedEditId);
exports.getSelectedFollowerIndexId = getSelectedFollowerIndexId;
const getSelectedFollowerIndex = (view = 'detail') => (0, _reselect.createSelector)(getFollowerIndexState, followerIndexState => {
  const propId = view === 'detail' ? 'selectedDetailId' : 'selectedEditId';
  if (!followerIndexState[propId]) {
    return null;
  }
  return followerIndexState.byId[followerIndexState[propId]];
});
exports.getSelectedFollowerIndex = getSelectedFollowerIndex;
const getListFollowerIndices = (0, _reselect.createSelector)(getFollowerIndices, followerIndices => (0, _utils.objectToArray)(followerIndices));
exports.getListFollowerIndices = getListFollowerIndices;