"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexResumeProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _routing = require("../../services/routing");
var _actions = require("../../store/actions");
var _utils = require("../../../../common/services/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FollowerIndexResumeProviderUi extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalOpen: false,
      ids: null
    });
    (0, _defineProperty2.default)(this, "onMouseOverModal", event => {
      // This component can sometimes be used inside of an EuiToolTip, in which case mousing over
      // the modal can trigger the tooltip. Stopping propagation prevents this.
      event.stopPropagation();
    });
    (0, _defineProperty2.default)(this, "resumeFollowerIndex", id => {
      this.setState({
        isModalOpen: true,
        ids: (0, _utils.arrify)(id)
      });
    });
    (0, _defineProperty2.default)(this, "onConfirm", () => {
      this.props.resumeFollowerIndex(this.state.ids);
      this.setState({
        isModalOpen: false,
        ids: null
      });
      this.props.onConfirm && this.props.onConfirm();
    });
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        isModalOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderModal", () => {
      const {
        ids
      } = this.state;
      const isSingle = ids.length === 1;
      const title = isSingle ? _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.resumeSingleTitle', {
        defaultMessage: `Resume replication to follower index '{name}'?`,
        values: {
          name: ids[0]
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.resumeMultipleTitle', {
        defaultMessage: `Resume replication to {count} follower indices?`,
        values: {
          count: ids.length
        }
      });
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
        _react.default.createElement(_eui.EuiConfirmModal, {
          title: title,
          onCancel: this.closeConfirmModal,
          onConfirm: this.onConfirm,
          cancelButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.cancelButtonText', {
            defaultMessage: 'Cancel'
          }),
          buttonColor: "primary",
          confirmButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.confirmButtonText', {
            defaultMessage: 'Resume replication'
          }),
          onMouseOver: this.onMouseOverModal,
          "data-test-subj": "resumeReplicationConfirmation"
        }, isSingle ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.singleResumeDescription",
          defaultMessage: "Replication resumes using the default advanced settings. To use custom advanced settings, {editLink}.",
          values: {
            editLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(_routing.routing._reactRouter.history, _routing.routing.getFollowerIndexPath(ids[0])), {
              "data-test-subj": "editLink"
            }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.singleResumeEditLink",
              defaultMessage: "edit the follower index"
            }))
          }
        })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.multipleResumeDescriptionWithSettingWarning",
          defaultMessage: "Replication resumes using the default advanced settings."
        })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.multipleResumeDescription",
          defaultMessage: "Replication will resume on these follower indices:"
        })), /*#__PURE__*/_react.default.createElement("ul", null, ids.map(id => /*#__PURE__*/_react.default.createElement("li", {
          key: id
        }, id)))))
      );
    });
  }
  render() {
    const {
      children
    } = this.props;
    const {
      isModalOpen
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(this.resumeFollowerIndex), isModalOpen && this.renderModal());
  }
}
(0, _defineProperty2.default)(FollowerIndexResumeProviderUi, "propTypes", {
  onConfirm: _propTypes.default.func
});
const mapDispatchToProps = dispatch => ({
  resumeFollowerIndex: id => dispatch((0, _actions.resumeFollowerIndex)(id))
});
const FollowerIndexResumeProvider = (0, _reactRedux.connect)(undefined, mapDispatchToProps)(FollowerIndexResumeProviderUi);
exports.FollowerIndexResumeProvider = FollowerIndexResumeProvider;