"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalValidateRoute = registerInternalValidateRoute;
var _configSchema = require("@kbn/config-schema");
var _ui_settings_errors = require("../../ui_settings_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerInternalValidateRoute(router) {
  const validateFromRequest = async (uiSettingsClient, context, request, response) => {
    try {
      const {
        key
      } = request.params;
      const {
        value
      } = request.body;
      const {
        valid,
        errorMessage
      } = await uiSettingsClient.validate(key, value);
      return response.ok({
        body: {
          valid,
          errorMessage
        }
      });
    } catch (error) {
      if (error instanceof _ui_settings_errors.ValidationSettingNotFoundError) {
        return response.notFound({
          body: error
        });
      }
      if (error instanceof _ui_settings_errors.ValidationBadValueError) {
        return response.badRequest({
          body: error
        });
      }
      throw error;
    }
  };
  router.post({
    path: '/internal/kibana/settings/{key}/validate',
    validate: {
      params: _configSchema.schema.object({
        key: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        value: _configSchema.schema.any()
      })
    },
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    const uiSettingsClient = (await context.core).uiSettings.client;
    return await validateFromRequest(uiSettingsClient, context, request, response);
  });
}