"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalRoutes = registerInternalRoutes;
var _delete = require("./delete");
var _get = require("./get");
var _set_many = require("./set_many");
var _set = require("./set");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerInternalRoutes(router) {
  (0, _get.registerInternalGetRoute)(router);
  (0, _delete.registerInternalDeleteRoute)(router);
  (0, _set.registerInternalSetRoute)(router);
  (0, _set_many.registerInternalSetManyRoute)(router);
  (0, _validate.registerInternalValidateRoute)(router);
}