"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logStateTransition = exports.logActionResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const logStateTransition = (logger, logPrefix, prevState, currState, tookMs) => {
  if (currState.logs.length > prevState.logs.length) {
    currState.logs.slice(prevState.logs.length).forEach(({
      message,
      level
    }) => {
      switch (level) {
        case 'error':
          return logger.error(logPrefix + message);
        case 'warning':
          return logger.warn(logPrefix + message);
        case 'info':
          return logger.info(logPrefix + message);
        default:
          throw new Error(`unexpected log level ${level}`);
      }
    });
  }
  const logMessage = `${logPrefix}${prevState.controlState} -> ${currState.controlState}. took: ${tookMs}ms.`;
  if (logger.isLevelEnabled('debug')) {
    logger.debug(logMessage, {
      kibana: {
        migrations: {
          state: currState,
          duration: tookMs
        }
      }
    });
  } else {
    logger.info(logMessage);
  }
};
exports.logStateTransition = logStateTransition;
const logActionResponse = (logger, logMessagePrefix, state, res) => {
  logger.debug(logMessagePrefix + `${state.controlState} RESPONSE`);
};
exports.logActionResponse = logActionResponse;