"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectsMigrationConfig = exports.savedObjectsConfig = exports.SavedObjectConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _semver = require("semver");
var _configSchema = require("@kbn/config-schema");
var _buffer = _interopRequireDefault(require("buffer"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const migrationSchema = _configSchema.schema.object({
  algorithm: _configSchema.schema.oneOf([_configSchema.schema.literal('v2'), _configSchema.schema.literal('zdt')], {
    defaultValue: 'v2'
  }),
  batchSize: _configSchema.schema.number({
    defaultValue: 1_000
  }),
  maxBatchSizeBytes: _configSchema.schema.byteSize({
    defaultValue: '100mb'
  }),
  // 100mb is the default http.max_content_length Elasticsearch config value
  maxReadBatchSizeBytes: _configSchema.schema.byteSize({
    defaultValue: _buffer.default.constants.MAX_STRING_LENGTH,
    max: _buffer.default.constants.MAX_STRING_LENGTH
  }),
  discardUnknownObjects: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: value => (0, _semver.valid)(value) ? undefined : 'The value is not a valid semantic version'
  })),
  discardCorruptObjects: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: value => (0, _semver.valid)(value) ? undefined : 'The value is not a valid semantic version'
  })),
  scrollDuration: _configSchema.schema.string({
    defaultValue: '15m'
  }),
  pollInterval: _configSchema.schema.number({
    defaultValue: 1_500
  }),
  skip: _configSchema.schema.boolean({
    defaultValue: false
  }),
  retryAttempts: _configSchema.schema.number({
    defaultValue: 15
  }),
  /**
   * ZDT algorithm specific options
   */
  zdt: _configSchema.schema.object({
    /**
     * The delay that the migrator will wait for, in seconds, when updating the
     * index mapping's meta to let the other nodes pickup the changes.
     */
    metaPickupSyncDelaySec: _configSchema.schema.number({
      min: 1,
      defaultValue: 5
    }),
    /**
     * The document migration phase will be run from instances with any of the specified roles.
     *
     * This is mostly used for testing environments and integration tests were
     * we have full control over a single node Kibana deployment.
     *
     * Defaults to ["migrator"]
     */
    runOnRoles: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: ['migrator']
    })
  })
});
const savedObjectsMigrationConfig = {
  path: 'migrations',
  schema: migrationSchema
};
exports.savedObjectsMigrationConfig = savedObjectsMigrationConfig;
const soSchema = _configSchema.schema.object({
  maxImportPayloadBytes: _configSchema.schema.byteSize({
    defaultValue: 26_214_400
  }),
  maxImportExportSize: _configSchema.schema.number({
    defaultValue: 10_000
  }),
  /* @internal Conditionally set default, dependening on if kibana's running from a dist build or not */
  allowHttpApiAccess: _configSchema.schema.conditional(_configSchema.schema.contextRef('dist'), true, _configSchema.schema.boolean({
    defaultValue: true
  }), _configSchema.schema.boolean({
    defaultValue: false
  }))
});
const savedObjectsConfig = {
  path: 'savedObjects',
  schema: soSchema
};
exports.savedObjectsConfig = savedObjectsConfig;
class SavedObjectConfig {
  /* @internal depend on env: see https://github.com/elastic/dev/issues/2200 */

  constructor(rawConfig, rawMigrationConfig) {
    (0, _defineProperty2.default)(this, "maxImportPayloadBytes", void 0);
    (0, _defineProperty2.default)(this, "maxImportExportSize", void 0);
    (0, _defineProperty2.default)(this, "allowHttpApiAccess", void 0);
    (0, _defineProperty2.default)(this, "migration", void 0);
    this.maxImportPayloadBytes = rawConfig.maxImportPayloadBytes.getValueInBytes();
    this.maxImportExportSize = rawConfig.maxImportExportSize;
    this.migration = rawMigrationConfig;
    this.allowHttpApiAccess = rawConfig.allowHttpApiAccess;
  }
}
exports.SavedObjectConfig = SavedObjectConfig;