"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKibanaTranslationFiles = void 0;
var _path = require("path");
var _repoInfo = require("@kbn/repo-info");
var _std = require("@kbn/std");
var _repoPackages = require("@kbn/repo-packages");
var _get_translation_paths = require("./get_translation_paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getKibanaTranslationFiles = async (locale, pluginPaths) => {
  const translationPaths = await Promise.all([(0, _get_translation_paths.getTranslationPaths)({
    cwd: (0, _repoInfo.fromRoot)('.'),
    nested: true
  }), (0, _std.asyncMapWithLimit)((0, _repoPackages.getPackages)((0, _repoInfo.fromRoot)('.')).filter((0, _repoPackages.getPluginPackagesFilter)({
    paths: pluginPaths
  })), 20, async pkg => await (0, _get_translation_paths.getTranslationPaths)({
    cwd: pkg.directory,
    nested: false
  })), (0, _std.asyncMapWithLimit)(pluginPaths, 20, async pluginPath => await (0, _get_translation_paths.getTranslationPaths)({
    cwd: pluginPath,
    nested: false
  })), (0, _get_translation_paths.getTranslationPaths)({
    cwd: (0, _repoInfo.fromRoot)('../kibana-extra'),
    nested: true
  })]);
  return translationPaths.flat(2).filter(translationPath => (0, _path.basename)(translationPath, '.json') === locale);
};
exports.getKibanaTranslationFiles = getKibanaTranslationFiles;