"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CdnConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _nodeUrl = require("node:url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class CdnConfig {
  constructor(url) {
    (0, _defineProperty2.default)(this, "url", void 0);
    if (url) {
      this.url = new _nodeUrl.URL(url); // This will throw for invalid URLs
    }
  }

  get host() {
    var _this$url$host, _this$url;
    return (_this$url$host = (_this$url = this.url) === null || _this$url === void 0 ? void 0 : _this$url.host) !== null && _this$url$host !== void 0 ? _this$url$host : undefined;
  }
  get baseHref() {
    if (this.url) {
      return this.url.pathname === '/' ? this.url.origin : (0, _nodeUrl.format)(this.url);
    }
  }
  getCspConfig() {
    const host = this.host;
    if (!host) return {};
    return {
      font_src: [host],
      img_src: [host],
      script_src: [host],
      style_src: [host],
      worker_src: [host],
      connect_src: [host]
    };
  }
  static from(input = {}) {
    return new CdnConfig(input.url);
  }
}
exports.CdnConfig = CdnConfig;