"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRetryableEsClientError = void 0;
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const retryResponseStatuses = [401,
// AuthorizationException
403,
// AuthenticationException
408,
// RequestTimeout
410,
// Gone
429,
// TooManyRequests -> ES circuit breaker
503,
// ServiceUnavailable
504 // GatewayTimeout
];

/**
 * Returns true if the given elasticsearch error should be retried
 * by retry-based resiliency systems such as the SO migration, false otherwise.
 */
const isRetryableEsClientError = e => {
  var _e$body, _e$body$error;
  if (e instanceof _elasticsearch.errors.NoLivingConnectionsError || e instanceof _elasticsearch.errors.ConnectionError || e instanceof _elasticsearch.errors.TimeoutError || e instanceof _elasticsearch.errors.ResponseError && (retryResponseStatuses.includes(e === null || e === void 0 ? void 0 : e.statusCode) ||
  // ES returns a 400 Bad Request when trying to close or delete an
  // index while snapshots are in progress. This should have been a 503
  // so once https://github.com/elastic/elasticsearch/issues/65883 is
  // fixed we can remove this.
  (e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : (_e$body$error = _e$body.error) === null || _e$body$error === void 0 ? void 0 : _e$body$error.type) === 'snapshot_in_progress_exception')) {
    return true;
  }
  return false;
};
exports.isRetryableEsClientError = isRetryableEsClientError;