"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TO_INDEX = exports.FROM_INDEX = void 0;
exports.getInterval = getInterval;
exports.getMomentTimezone = getMomentTimezone;
exports.getStepSize = getStepSize;
exports.getTicks = getTicks;
exports.roundDownToNextStepSizeFactor = roundDownToNextStepSizeFactor;
exports.roundUpToNextStepSizeFactor = roundUpToNextStepSizeFactor;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MAX_TICKS = 20; // eui range has hard limit of 20 ticks and throws when exceeded

const FROM_INDEX = 0;
exports.FROM_INDEX = FROM_INDEX;
const TO_INDEX = 1;
exports.TO_INDEX = TO_INDEX;
function getMomentTimezone(dateFormatTZ) {
  const detectedTimezone = _momentTimezone.default.tz.guess();
  return dateFormatTZ === undefined || dateFormatTZ === 'Browser' ? detectedTimezone : dateFormatTZ;
}
function getScaledDateFormat(interval) {
  if (interval >= _momentTimezone.default.duration(1, 'y').asMilliseconds()) {
    return 'YYYY';
  }
  if (interval >= _momentTimezone.default.duration(30, 'd').asMilliseconds()) {
    return 'MMM YYYY';
  }
  if (interval >= _momentTimezone.default.duration(1, 'd').asMilliseconds()) {
    return 'MMM D';
  }
  if (interval >= _momentTimezone.default.duration(6, 'h').asMilliseconds()) {
    return 'Do HH';
  }
  if (interval >= _momentTimezone.default.duration(1, 'h').asMilliseconds()) {
    return 'HH:mm';
  }
  if (interval >= _momentTimezone.default.duration(1, 'm').asMilliseconds()) {
    return 'HH:mm';
  }
  if (interval >= _momentTimezone.default.duration(1, 's').asMilliseconds()) {
    return 'mm:ss';
  }
  return 'ss.SSS';
}
function getInterval(min, max, steps = MAX_TICKS) {
  const duration = max - min;
  let interval = (0, _common.calcAutoIntervalNear)(MAX_TICKS, duration).asMilliseconds();
  // Sometimes auto interval is not quite right and returns 2X, 3X, 1/2X, or 1/3X  requested ticks
  const actualSteps = duration / interval;
  if (actualSteps > MAX_TICKS) {
    // EuiRange throws if ticks exceeds MAX_TICKS
    // Adjust the interval to ensure MAX_TICKS is never exceeded
    const factor = Math.ceil(actualSteps / MAX_TICKS);
    interval = interval * factor;
  } else if (actualSteps < MAX_TICKS / 2) {
    // Increase number of ticks when ticks is less then half MAX_TICKS
    interval = interval / 2;
  }
  return interval;
}
function getTicks(min, max, timezone) {
  const interval = getInterval(min, max);
  const format = getScaledDateFormat(interval);
  let tick = Math.ceil(min / interval) * interval;
  const ticks = [];
  while (tick <= max) {
    ticks.push({
      value: tick,
      label: _momentTimezone.default.tz(tick, getMomentTimezone(timezone)).format(format)
    });
    tick += interval;
  }
  return ticks;
}
function getStepSize(ticks) {
  if (ticks.length < 2) {
    return {
      stepSize: 1,
      format: 'MMM D, YYYY @ HH:mm:ss.SSS'
    };
  }
  const tickRange = ticks[1].value - ticks[0].value;
  if (tickRange >= _momentTimezone.default.duration(2, 'y').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'y').asMilliseconds(),
      format: 'YYYY'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 'd').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'd').asMilliseconds(),
      format: 'MMM D, YYYY'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 'h').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'h').asMilliseconds(),
      format: 'MMM D, YYYY @ HH:mm'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 'm').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'm').asMilliseconds(),
      format: 'MMM D, YYYY @ HH:mm'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 's').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 's').asMilliseconds(),
      format: 'MMM D, YYYY @ HH:mm:ss'
    };
  }
  return {
    stepSize: 1,
    format: 'MMM D, YYYY @ HH:mm:ss.SSS'
  };
}
function roundDownToNextStepSizeFactor(value, stepSize) {
  const remainder = value % stepSize;
  return remainder === 0 ? value : value - remainder;
}
function roundUpToNextStepSizeFactor(value, stepSize) {
  const remainder = value % stepSize;
  return remainder === 0 ? value : value + (stepSize - remainder);
}