"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rangeSliderReducers = exports.getDefaultComponentState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDefaultComponentState = () => ({
  isInvalid: false
});
exports.getDefaultComponentState = getDefaultComponentState;
const rangeSliderReducers = {
  setSelectedRange: (state, action) => {
    state.explicitInput.value = action.payload;
  },
  setField: (state, action) => {
    state.componentState.field = action.payload;
  },
  setDataViewId: (state, action) => {
    state.output.dataViewId = action.payload;
  },
  setErrorMessage: (state, action) => {
    state.componentState.error = action.payload;
  },
  setLoading: (state, action) => {
    state.output.loading = action.payload;
  },
  setMinMax: (state, action) => {
    if (action.payload.min !== undefined) state.componentState.min = Math.floor(action.payload.min);
    if (action.payload.max !== undefined) state.componentState.max = Math.ceil(action.payload.max);
  },
  publishFilters: (state, action) => {
    state.output.filters = action.payload;
  },
  setIsInvalid: (state, action) => {
    state.componentState.isInvalid = action.payload;
  }
};
exports.rangeSliderReducers = rangeSliderReducers;