"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverSortingButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _suggestions_sorting = require("../../../common/options_list/suggestions_sorting");
var _options_list_strings = require("./options_list_strings");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const sortOrderOptions = [{
  id: 'asc',
  iconType: `sortAscending`,
  'data-test-subj': `optionsList__sortOrder_asc`,
  label: _options_list_strings.OptionsListStrings.editorAndPopover.sortOrder.asc.getSortOrderLabel()
}, {
  id: 'desc',
  iconType: `sortDescending`,
  'data-test-subj': `optionsList__sortOrder_desc`,
  label: _options_list_strings.OptionsListStrings.editorAndPopover.sortOrder.desc.getSortOrderLabel()
}];
const OptionsListPopoverSortingButton = ({
  showOnlySelected
}) => {
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const field = optionsList.select(state => state.componentState.field);
  const sort = optionsList.select(state => {
    var _state$explicitInput$;
    return (_state$explicitInput$ = state.explicitInput.sort) !== null && _state$explicitInput$ !== void 0 ? _state$explicitInput$ : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT;
  });
  const [isSortingPopoverOpen, setIsSortingPopoverOpen] = (0, _react.useState)(false);
  const [sortByOptions, setSortByOptions] = (0, _react.useState)(() => {
    return (0, _suggestions_sorting.getCompatibleSortingTypes)(field === null || field === void 0 ? void 0 : field.type).map(key => {
      return {
        onFocusBadge: false,
        data: {
          sortBy: key
        },
        checked: key === sort.by ? 'on' : undefined,
        'data-test-subj': `optionsList__sortBy_${key}`,
        label: _options_list_strings.OptionsListStrings.editorAndPopover.sortBy[key].getSortByLabel(field === null || field === void 0 ? void 0 : field.type)
      };
    });
  });
  const onSortByChange = (0, _react.useCallback)(updatedOptions => {
    setSortByOptions(updatedOptions);
    const selectedOption = updatedOptions.find(({
      checked
    }) => checked === 'on');
    if (selectedOption) {
      optionsList.dispatch.setSort({
        by: selectedOption.data.sortBy
      });
    }
  }, [optionsList.dispatch]);
  const SortButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    display: "empty",
    color: "text",
    iconType: (sort === null || sort === void 0 ? void 0 : sort.direction) === 'asc' ? 'sortAscending' : 'sortDescending',
    isDisabled: showOnlySelected,
    className: "optionsList__sortButton",
    "data-test-subj": "optionsListControl__sortingOptionsButton",
    onClick: () => setIsSortingPopoverOpen(!isSortingPopoverOpen),
    "aria-label": _options_list_strings.OptionsListStrings.popover.getSortPopoverDescription()
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getSortDisabledTooltip() : _options_list_strings.OptionsListStrings.popover.getSortPopoverTitle()
    }, /*#__PURE__*/_react.default.createElement(SortButton, null)),
    panelPaddingSize: "none",
    isOpen: isSortingPopoverOpen,
    "aria-labelledby": "optionsList_sortingOptions",
    closePopover: () => setIsSortingPopoverOpen(false),
    panelClassName: 'optionsList--sortPopover',
    anchorClassName: 'optionsList__sortButtonPopoverAnchor'
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "optionsListControl__sortingOptionsPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _options_list_strings.OptionsListStrings.popover.getSortPopoverTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isIconOnly: true,
    buttonSize: "compressed",
    options: sortOrderOptions,
    idSelected: sort.direction,
    legend: _options_list_strings.OptionsListStrings.editorAndPopover.getSortDirectionLegend(),
    onChange: value => optionsList.dispatch.setSort({
      direction: value
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: sortByOptions,
    singleSelection: "always",
    onChange: onSortByChange,
    id: "optionsList_sortingOptions",
    listProps: {
      bordered: false
    },
    "data-test-subj": "optionsListControl__sortingOptions",
    "aria-label": _options_list_strings.OptionsListStrings.popover.getSortPopoverDescription()
  }, list => list)));
};
exports.OptionsListPopoverSortingButton = OptionsListPopoverSortingButton;