"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openEditControlGroupFlyout = openEditControlGroupFlyout;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _services = require("../../services");
var _control_group_strings = require("../control_group_strings");
var _control_group_container = require("../embeddable/control_group_container");
var _control_group_editor = require("./control_group_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function openEditControlGroupFlyout() {
  var _this$getInput$panels;
  const {
    core: {
      theme,
      i18n
    },
    overlays: {
      openFlyout,
      openConfirm
    }
  } = _services.pluginServices.getServices();
  const onDeleteAll = ref => {
    openConfirm(_control_group_strings.ControlGroupStrings.management.deleteControls.getSubtitle(), {
      confirmButtonText: _control_group_strings.ControlGroupStrings.management.deleteControls.getConfirm(),
      cancelButtonText: _control_group_strings.ControlGroupStrings.management.deleteControls.getCancel(),
      title: _control_group_strings.ControlGroupStrings.management.deleteControls.getDeleteAllTitle(),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) Object.keys(this.getInput().panels).forEach(panelId => this.removeEmbeddable(panelId));
      ref.close();
    });
  };
  const flyoutInstance = openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_control_group_container.ControlGroupContainerContext.Provider, {
    value: this
  }, /*#__PURE__*/_react.default.createElement(_control_group_editor.ControlGroupEditor, {
    initialInput: this.getInput(),
    updateInput: changes => this.updateInput(changes),
    controlCount: Object.keys((_this$getInput$panels = this.getInput().panels) !== null && _this$getInput$panels !== void 0 ? _this$getInput$panels : {}).length,
    onDeleteAll: () => onDeleteAll(flyoutInstance),
    onClose: () => flyoutInstance.close()
  })), {
    theme,
    i18n
  }), {
    'aria-label': _control_group_strings.ControlGroupStrings.manageControl.getFlyoutCreateTitle(),
    outsideClickCloses: false,
    onClose: () => {
      this.closeAllFlyouts();
    }
  });
  (0, _control_group_container.setFlyoutRef)(flyoutInstance);
}