"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupEditor = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _editor_constants = require("./editor_constants");
var _control_group_strings = require("../control_group_strings");
var _common = require("../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const editorControlGroupInputIsEqual = (a, b) => (0, _fastDeepEqual.default)(a, b);
const ControlGroupEditor = ({
  controlCount,
  initialInput,
  updateInput,
  onDeleteAll,
  onClose
}) => {
  var _controlGroupEditorSt2;
  const [controlGroupEditorState, setControlGroupEditorState] = (0, _react.useState)({
    ...(0, _common.getDefaultControlGroupInput)(),
    ...initialInput
  });
  const updateControlGroupEditorSetting = (0, _react.useCallback)(newSettings => {
    setControlGroupEditorState({
      ...controlGroupEditorState,
      ...newSettings
    });
  }, [controlGroupEditorState]);
  const updateIgnoreSetting = (0, _react.useCallback)(newSettings => {
    var _controlGroupEditorSt;
    setControlGroupEditorState({
      ...controlGroupEditorState,
      ignoreParentSettings: {
        ...((_controlGroupEditorSt = controlGroupEditorState.ignoreParentSettings) !== null && _controlGroupEditorSt !== void 0 ? _controlGroupEditorSt : {}),
        ...newSettings
      }
    });
  }, [controlGroupEditorState]);
  const applyChangesToInput = (0, _react.useCallback)(() => {
    const inputToApply = {
      ...controlGroupEditorState
    };
    if (!editorControlGroupInputIsEqual(inputToApply, initialInput)) updateInput(inputToApply);
  }, [controlGroupEditorState, initialInput, updateInput]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _control_group_strings.ControlGroupStrings.management.getFlyoutTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "control-group-settings-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.management.labelPosition.getLabelPositionTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    options: _editor_constants.CONTROL_LAYOUT_OPTIONS,
    "data-test-subj": "control-group-layout-options",
    idSelected: controlGroupEditorState.controlStyle,
    legend: _control_group_strings.ControlGroupStrings.management.labelPosition.getLabelPositionLegend(),
    onChange: newControlStyle => {
      // The UI copy calls this setting labelPosition, but to avoid an unnecessary migration it will be left as controlStyle in the state.
      updateControlGroupEditorSetting({
        controlStyle: newControlStyle
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "control-group-validate-selections",
    label: _control_group_strings.ControlGroupStrings.management.validateSelections.getValidateSelectionsTitle(),
    showLabel: false,
    checked: !Boolean((_controlGroupEditorSt2 = controlGroupEditorState.ignoreParentSettings) === null || _controlGroupEditorSt2 === void 0 ? void 0 : _controlGroupEditorSt2.ignoreValidations),
    onChange: e => updateIgnoreSetting({
      ignoreValidations: !e.target.checked
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _control_group_strings.ControlGroupStrings.management.validateSelections.getValidateSelectionsTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _control_group_strings.ControlGroupStrings.management.validateSelections.getValidateSelectionsSubTitle())))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "control-group-chaining",
    label: _control_group_strings.ControlGroupStrings.management.controlChaining.getHierarchyTitle(),
    showLabel: false,
    checked: controlGroupEditorState.chainingSystem === 'HIERARCHICAL',
    onChange: e => updateControlGroupEditorSetting({
      chainingSystem: e.target.checked ? 'HIERARCHICAL' : 'NONE'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _control_group_strings.ControlGroupStrings.management.controlChaining.getHierarchyTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _control_group_strings.ControlGroupStrings.management.controlChaining.getHierarchySubTitle())))), controlCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDeleteAll,
    "data-test-subj": "delete-all-controls-button",
    "aria-label": 'delete-all',
    iconType: "trash",
    color: "danger",
    flush: "left",
    size: "s"
  }, _control_group_strings.ControlGroupStrings.management.getDeleteAllButtonTitle())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `cancel-editing-group`,
    iconType: "cross",
    onClick: () => {
      onClose();
    }
  }, _control_group_strings.ControlGroupStrings.manageControl.getCancelTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `save-group`,
    iconType: "check",
    color: "primary",
    "data-test-subj": "control-group-editor-save",
    onClick: () => {
      applyChangesToInput();
      onClose();
    }
  }, _control_group_strings.ControlGroupStrings.manageControl.getSaveChangesTitle())))));
};
exports.ControlGroupEditor = ControlGroupEditor;