"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _services = require("./services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class ConsoleUIPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "autocompleteInfo", new _services.AutocompleteInfo());
    this.ctx = ctx;
  }
  setup({
    notifications,
    getStartServices,
    http
  }, {
    devTools,
    home,
    share,
    usageCollection
  }) {
    const {
      ui: {
        enabled: isConsoleUiEnabled
      }
    } = this.ctx.config.get();
    this.autocompleteInfo.setup(http);
    (0, _services.setAutocompleteInfo)(this.autocompleteInfo);
    if (isConsoleUiEnabled) {
      if (home) {
        home.featureCatalogue.register({
          id: 'console',
          title: _i18n.i18n.translate('console.devToolsTitle', {
            defaultMessage: 'Interact with the Elasticsearch API'
          }),
          description: _i18n.i18n.translate('console.devToolsDescription', {
            defaultMessage: 'Skip cURL and use a JSON interface to work with your data in Console.'
          }),
          icon: 'consoleApp',
          path: '/app/dev_tools#/console',
          showOnHomePage: false,
          category: 'admin'
        });
      }
      devTools.register({
        id: 'console',
        order: 1,
        title: _i18n.i18n.translate('console.consoleDisplayName', {
          defaultMessage: 'Console'
        }),
        enableRouting: false,
        mount: async ({
          element,
          theme$
        }) => {
          const [core] = await getStartServices();
          const {
            i18n: {
              Context: I18nContext
            },
            docLinks: {
              DOC_LINK_VERSION,
              links
            }
          } = core;
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          return renderApp({
            http,
            docLinkVersion: DOC_LINK_VERSION,
            docLinks: links,
            I18nContext,
            notifications,
            usageCollection,
            element,
            theme$,
            autocompleteInfo: this.autocompleteInfo
          });
        }
      });
      const locator = share.url.locators.create({
        id: 'CONSOLE_APP_LOCATOR',
        getLocation: async ({
          loadFrom
        }) => {
          return {
            app: 'dev_tools',
            path: `#/console${loadFrom ? `?load_from=${loadFrom}` : ''}`,
            state: {
              loadFrom
            }
          };
        }
      });
      return {
        locator
      };
    }
    return {};
  }
  start() {}
}
exports.ConsoleUIPlugin = ConsoleUIPlugin;