"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Mode = void 0;
var _brace = _interopRequireDefault(require("brace"));
var _output_highlight_rules = require("./output_highlight_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const JSONMode = _brace.default.acequire('ace/mode/json').Mode;
const MatchingBraceOutdent = _brace.default.acequire('ace/mode/matching_brace_outdent').MatchingBraceOutdent;
const CstyleBehaviour = _brace.default.acequire('ace/mode/behaviour/cstyle').CstyleBehaviour;
const CStyleFoldMode = _brace.default.acequire('ace/mode/folding/cstyle').FoldMode;
_brace.default.acequire('ace/worker/worker_client');
const AceTokenizer = _brace.default.acequire('ace/tokenizer').Tokenizer;
class Mode extends JSONMode {
  constructor() {
    super();
    this.$tokenizer = new AceTokenizer(new _output_highlight_rules.OutputJsonHighlightRules().getRules());
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = new CstyleBehaviour();
    this.foldingRules = new CStyleFoldMode();
  }
}
exports.Mode = Mode;
(function () {
  this.createWorker = function () {
    return null;
  };
  this.$id = 'sense/mode/input';
}).call(Mode.prototype);