"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Mode = void 0;
var _brace = _interopRequireDefault(require("brace"));
var _worker = require("./worker");
var _script = require("./script");
var _input_highlight_rules = require("./input_highlight_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TextMode = _brace.default.acequire('ace/mode/text').Mode;
const MatchingBraceOutdent = _brace.default.acequire('ace/mode/matching_brace_outdent').MatchingBraceOutdent;
const CstyleBehaviour = _brace.default.acequire('ace/mode/behaviour/cstyle').CstyleBehaviour;
const CStyleFoldMode = _brace.default.acequire('ace/mode/folding/cstyle').FoldMode;
const WorkerClient = _brace.default.acequire('ace/worker/worker_client').WorkerClient;
const AceTokenizer = _brace.default.acequire('ace/tokenizer').Tokenizer;
class Mode extends TextMode {
  constructor() {
    super();
    this.$tokenizer = new AceTokenizer(new _input_highlight_rules.InputHighlightRules().getRules());
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = new CstyleBehaviour();
    this.foldingRules = new CStyleFoldMode();
    this.createModeDelegates({
      'script-': _script.ScriptMode
    });
  }
}
exports.Mode = Mode;
(function () {
  this.getCompletions = function () {
    // autocomplete is done by the autocomplete module.
    return [];
  };
  this.getNextLineIndent = function (state, line, tab) {
    let indent = this.$getIndent(line);
    if (state !== 'string_literal') {
      const match = line.match(/^.*[\{\(\[]\s*$/);
      if (match) {
        indent += tab;
      }
    }
    return indent;
  };
  this.checkOutdent = function (state, line, input) {
    return this.$outdent.checkOutdent(line, input);
  };
  this.autoOutdent = function (state, doc, row) {
    this.$outdent.autoOutdent(doc, row);
  };
  this.createWorker = function (session) {
    const worker = new WorkerClient(['ace', 'sense_editor'], _worker.workerModule, 'SenseWorker');
    worker.attachToDocument(session.getDocument());
    worker.on('error', function (e) {
      session.setAnnotations([e.data]);
    });
    worker.on('ok', function (anno) {
      session.setAnnotations(anno.data);
    });
    return worker;
  };
}).call(Mode.prototype);