"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = void 0;
var _brace = _interopRequireDefault(require("brace"));
var _legacy_core_editor = require("./legacy_core_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const create = el => {
  const actions = document.querySelector('#ConAppEditorActions');
  if (!actions) {
    throw new Error('Could not find ConAppEditorActions element!');
  }
  const aceEditor = _brace.default.edit(el);
  return new _legacy_core_editor.LegacyCoreEditor(aceEditor, actions);
};
exports.create = create;