"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestContextProvider = RequestContextProvider;
exports.useRequestReadContext = exports.useRequestActionContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _create_use_context = require("./create_use_context");
var store = _interopRequireWildcard(require("../stores/request"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RequestReadContext = /*#__PURE__*/(0, _react.createContext)(store.initialValue);
const RequestActionContext = /*#__PURE__*/(0, _react.createContext)(() => {});
function RequestContextProvider({
  children
}) {
  const [state, dispatch] = (0, _react.useReducer)(store.reducer, store.initialValue);
  return /*#__PURE__*/_react.default.createElement(RequestReadContext.Provider, {
    value: state
  }, /*#__PURE__*/_react.default.createElement(RequestActionContext.Provider, {
    value: dispatch
  }, children));
}
const useRequestReadContext = (0, _create_use_context.createUseContext)(RequestReadContext, 'RequestReadContext');
exports.useRequestReadContext = useRequestReadContext;
const useRequestActionContext = (0, _create_use_context.createUseContext)(RequestActionContext, 'RequestActionContext');
exports.useRequestActionContext = useRequestActionContext;