"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpPanel = HelpPanel;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _editor_example = _interopRequireDefault(require("./editor_example"));
var _contexts = require("../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function HelpPanel(props) {
  const {
    docLinks
  } = (0, _contexts.useServicesContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: props.onClose,
    "data-test-subj": "helpFlyout",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.pageTitle",
    defaultMessage: "Help"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Request format",
    id: "console.helpPage.requestFormatTitle"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.requestFormatDescription",
    defaultMessage: "You can type one or more requests in the editor. Console understands requests in a compact format."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.learnAboutConsoleAndQueryDslText",
    defaultMessage: "Learn about {console} and {queryDsl}",
    values: {
      console: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.console.guide,
        target: "_blank",
        external: true
      }, "Console"),
      queryDsl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.query.queryDsl,
        target: "_blank",
        external: true
      }, "Query DSL")
    }
  })), /*#__PURE__*/_react.default.createElement(_editor_example.default, {
    panel: "help"
  }), /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommandsTitle",
    defaultMessage: "Keyboard commands"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("dl", null, /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl/Cmd + I"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.autoIndentDescription",
    defaultMessage: "Auto indent current request"
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl/Cmd + /"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.openDocumentationDescription",
    defaultMessage: "Open documentation for current request"
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl + Space"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.openAutoCompleteDescription",
    defaultMessage: "Open Auto complete (even if not typing)"
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl/Cmd + Enter"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.submitRequestDescription",
    defaultMessage: "Submit request"
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl/Cmd + Up/Down"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.jumpToPreviousNextRequestDescription",
    defaultMessage: "Jump to the previous/next request start or end."
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl/Cmd + Alt + L"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.collapseExpandCurrentScopeDescription",
    defaultMessage: "Collapse/expand current scope."
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl/Cmd + Option + 0"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.collapseAllScopesDescription",
    defaultMessage: "Collapse all scopes but the current one. Expand by adding a shift."
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Down arrow"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.switchFocusToAutoCompleteMenuDescription",
    defaultMessage: "Switch focus to auto-complete menu. Use arrows to further select a term"
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Enter/Tab"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.selectCurrentlySelectedInAutoCompleteMenuDescription",
    defaultMessage: "Select the currently selected or the top most term in auto-complete menu"
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Ctrl/Cmd + L"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.goToLineNumberDescription",
    defaultMessage: "Go to line number"
  })), /*#__PURE__*/_react.default.createElement("dt", null, "Esc"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.helpPage.keyboardCommands.closeAutoCompleteMenuDescription",
    defaultMessage: "Close auto-complete menu"
  }))))));
}