"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaletteSelector = PaletteSelector;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _color_mapping = require("../../state/color_mapping");
var _assignments = require("../../config/assignments");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function PaletteSelector({
  palettes,
  getPaletteFn,
  isDarkMode
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const colorMode = (0, _reactRedux.useSelector)(state => state.colorMapping.colorMode);
  const model = (0, _reactRedux.useSelector)(state => state.colorMapping);
  const {
    paletteId
  } = model;
  const switchPaletteFn = (0, _react.useCallback)((selectedPaletteId, preserveColorChanges) => {
    dispatch((0, _color_mapping.updatePalette)({
      paletteId: selectedPaletteId,
      assignments: (0, _assignments.updateAssignmentsPalette)(model.assignments, model.assignmentMode, model.colorMode, selectedPaletteId, getPaletteFn, preserveColorChanges),
      colorMode: (0, _assignments.updateColorModePalette)(model.colorMode, selectedPaletteId, preserveColorChanges)
    }));
  }, [getPaletteFn, model, dispatch]);
  const updateColorMode = (0, _react.useCallback)((type, preserveColorChanges) => {
    const updatedColorMode = type === 'gradient' ? {
      type: 'gradient',
      steps: [{
        type: 'categorical',
        paletteId,
        colorIndex: 0,
        touched: false
      }],
      sort: 'desc'
    } : {
      type: 'categorical'
    };
    const assignments = (0, _assignments.updateAssignmentsPalette)(model.assignments, model.assignmentMode, updatedColorMode, paletteId, getPaletteFn, preserveColorChanges);
    dispatch((0, _color_mapping.updatePalette)({
      paletteId,
      assignments,
      colorMode: updatedColorMode
    }));
  }, [getPaletteFn, model, dispatch, paletteId]);
  const [preserveModalPaletteId, setPreserveModalPaletteId] = (0, _react.useState)(null);
  const preserveChangesModal = preserveModalPaletteId !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.title', {
      defaultMessage: 'Color changes detected'
    }),
    onCancel: () => {
      if (preserveModalPaletteId) switchPaletteFn(preserveModalPaletteId, true);
      setPreserveModalPaletteId(null);
    },
    onConfirm: () => {
      if (preserveModalPaletteId) switchPaletteFn(preserveModalPaletteId, false);
      setPreserveModalPaletteId(null);
    },
    confirmButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.discardButton', {
      defaultMessage: 'Discard changes'
    }),
    cancelButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.preserveButton', {
      defaultMessage: 'Preserve changes'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.switchPaletteDescription', {
    defaultMessage: 'Switching palette will discard all your custom color changes'
  }))) : null;
  const [colorScaleModalId, setColorScaleModalId] = (0, _react.useState)(null);
  const colorScaleModal = colorScaleModalId !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.modalTitle', {
      defaultMessage: 'Color changes detected'
    }),
    onCancel: () => {
      setColorScaleModalId(null);
    },
    onConfirm: () => {
      if (colorScaleModalId) updateColorMode(colorScaleModalId, false);
      setColorScaleModalId(null);
    },
    cancelButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.goBackButtonLabel', {
      defaultMessage: 'Go back'
    }),
    confirmButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.discardButtonLabel', {
      defaultMessage: 'Discard changes'
    }),
    defaultFocusedButton: "confirm",
    buttonColor: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, colorScaleModalId === 'categorical' ? _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.categoricalModeDescription', {
    defaultMessage: `Switching to a categorical mode will discard all your custom color changes`
  }) : _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.sequentialModeDescription', {
    defaultMessage: `Switching to a sequential mode will discard all your custom color changes`
  }))) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, preserveChangesModal, colorScaleModal, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.paletteLabel', {
      defaultMessage: `Color palette`
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    "data-test-subj": "kbnColoring_ColorMapping_PalettePicker",
    palettes: [...palettes.values()].filter(d => d.name !== 'Neutral').map(palette => ({
      'data-test-subj': `kbnColoring_ColorMapping_Palette-${palette.id}`,
      value: palette.id,
      title: palette.name,
      palette: Array.from({
        length: palette.colorCount
      }, (_, i) => {
        return palette.getColor(i, isDarkMode);
      }),
      type: 'fixed'
    })),
    onChange: selectedPaletteId => {
      const hasChanges = model.assignments.some(a => a.touched);
      const hasGradientChanges = model.colorMode.type === 'gradient' && model.colorMode.steps.some(a => a.touched);
      if (hasChanges || hasGradientChanges) {
        setPreserveModalPaletteId(selectedPaletteId);
      } else {
        switchPaletteFn(selectedPaletteId, false);
      }
    },
    valueOfSelected: model.paletteId,
    selectionDisplay: 'palette',
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.scaleLabel', {
      defaultMessage: `Scale`
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "Scale",
    "data-test-subj": "lns_colorMapping_scaleSwitch",
    options: [{
      id: `categorical`,
      label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.categoricalLabel', {
        defaultMessage: `Categorical`
      }),
      iconType: 'palette'
    }, {
      id: `gradient`,
      label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.sequentialLabel', {
        defaultMessage: `Sequential`
      }),
      iconType: 'gradient'
    }],
    isFullWidth: true,
    buttonSize: "compressed",
    idSelected: colorMode.type,
    onChange: id => {
      const hasChanges = model.assignments.some(a => a.touched);
      const hasGradientChanges = model.colorMode.type === 'gradient' && model.colorMode.steps.some(a => a.touched);
      if (hasChanges || hasGradientChanges) {
        setColorScaleModalId(id);
      } else {
        updateColorMode(id, false);
      }
    },
    isIconOnly: true
  })))));
}