"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Container = Container;
exports.MAX_ASSIGNABLE_COLORS = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _assignment = require("../assignment/assignment");
var _special_assignment = require("../assignment/special_assignment");
var _palette_selector = require("../palette_selector/palette_selector");
var _color_mapping = require("../../state/color_mapping");
var _assignment_from_categories = require("../../config/assignment_from_categories");
var _palettes = require("../../palettes");
var _assignments = require("../../config/assignments");
var _selectors = require("../../state/selectors");
var _gradient = require("../palette_selector/gradient");
var _neutral = require("../../palettes/neutral");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MAX_ASSIGNABLE_COLORS = 10;
exports.MAX_ASSIGNABLE_COLORS = MAX_ASSIGNABLE_COLORS;
function selectComputedAssignments(data, palette, colorMode) {
  return state => state.colorMapping.assignmentMode === 'auto' ? (0, _assignment_from_categories.generateAutoAssignmentsForCategories)(data, palette, colorMode) : state.colorMapping.assignments;
}
function Container(props) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getPaletteFn = (0, _palettes.getPalette)(props.palettes, _neutral.NeutralPalette);
  const palette = (0, _reactRedux.useSelector)((0, _selectors.selectPalette)(getPaletteFn));
  const colorMode = (0, _reactRedux.useSelector)(_selectors.selectColorMode);
  const autoAssignmentMode = (0, _reactRedux.useSelector)(_selectors.selectIsAutoAssignmentMode);
  const assignments = (0, _reactRedux.useSelector)(selectComputedAssignments(props.data, palette, colorMode));
  const specialAssignments = (0, _reactRedux.useSelector)(_selectors.selectSpecialAssignments);
  const canAddNewAssignment = !autoAssignmentMode && assignments.length < MAX_ASSIGNABLE_COLORS;
  const assignmentValuesCounter = assignments.reduce((acc, assignment) => {
    const values = assignment.rule.type === 'matchExactly' ? assignment.rule.values : [];
    values.forEach(value => {
      var _acc$get;
      acc.set(value, ((_acc$get = acc.get(value)) !== null && _acc$get !== void 0 ? _acc$get : 0) + 1);
    });
    return acc;
  }, new Map());
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_palette_selector.PaletteSelector, {
    palettes: props.palettes,
    getPaletteFn: getPaletteFn,
    isDarkMode: props.isDarkMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('coloring.colorMapping.container.mappingAssignmentHeader', {
    defaultMessage: 'Mapping assignments'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "lns-colorMapping-autoAssignSwitch",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('coloring.colorMapping.container.autoAssignLabel', {
      defaultMessage: 'Auto assign'
    })),
    checked: autoAssignmentMode,
    compressed: true,
    onChange: () => {
      if (autoAssignmentMode) {
        dispatch((0, _color_mapping.assignStatically)(assignments));
      } else {
        dispatch((0, _color_mapping.assignAutomatically)());
      }
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "lns-colorMapping-assignmentsList",
    css: (0, _react2.css)`
              display: grid;
              grid-template-columns: ${colorMode.type === 'gradient' ? '[gradient] 16px' : ''} [assignment] auto;
              gap: 8px;
            `
  }, colorMode.type !== 'gradient' ? null : /*#__PURE__*/_react.default.createElement(_gradient.Gradient, {
    colorMode: colorMode,
    getPaletteFn: getPaletteFn,
    isDarkMode: props.isDarkMode,
    paletteId: palette.id,
    assignmentsSize: assignments.length
  }), assignments.map((assignment, i) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: i,
      css: (0, _react2.css)`
                    position: relative;
                    grid-column: ${colorMode.type === 'gradient' ? 2 : 1};
                    grid-row: ${i + 1};
                    width: 100%;
                  `
    }, /*#__PURE__*/_react.default.createElement(_assignment.Assignment, {
      data: props.data,
      index: i,
      total: assignments.length,
      colorMode: colorMode,
      editable: !autoAssignmentMode,
      canPickColor: !autoAssignmentMode && colorMode.type !== 'gradient',
      palette: palette,
      isDarkMode: props.isDarkMode,
      getPaletteFn: getPaletteFn,
      assignment: assignment,
      disableDelete: assignments.length <= 1 || autoAssignmentMode,
      specialTokens: props.specialTokens,
      assignmentValuesCounter: assignmentValuesCounter
    }));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "lns-colorMapping-specialAssignmentsList"
  }, props.data.type === 'categories' && specialAssignments.map((assignment, i) => {
    return /*#__PURE__*/_react.default.createElement(_special_assignment.SpecialAssignment, {
      key: i,
      index: i,
      palette: palette,
      isDarkMode: props.isDarkMode,
      getPaletteFn: getPaletteFn,
      assignment: assignment,
      total: specialAssignments.length
    });
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      display: 'block'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "lns-colorMapping-addNewAssignment",
    iconType: "plusInCircleFilled",
    size: "xs",
    flush: "both",
    onClick: () => {
      dispatch((0, _color_mapping.addNewAssignment)({
        rule: props.data.type === 'categories' ? {
          type: 'matchExactly',
          values: []
        } : {
          type: 'range',
          min: 0,
          max: 0,
          minInclusive: true,
          maxInclusive: true
        },
        color: (0, _assignments.getUnusedColorForNewAssignment)(palette, colorMode, assignments),
        touched: false
      }));
    },
    disabled: !canAddNewAssignment,
    css: (0, _react2.css)`
                margin-right: 8px;
              `
  }, _i18n.i18n.translate('coloring.colorMapping.container.addAssignmentButtonLabel', {
    defaultMessage: 'Add assignment'
  })), colorMode.type === 'gradient' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    "data-test-subj": "lns-colorMapping-invertGradient",
    iconType: "sortable",
    size: "xs",
    onClick: () => {
      dispatch((0, _color_mapping.changeGradientSortOrder)(colorMode.sort === 'asc' ? 'desc' : 'asc'));
    }
  }, _i18n.i18n.translate('coloring.colorMapping.container.invertGradientButtonLabel', {
    defaultMessage: 'Invert gradient'
  }))))));
}