"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Range = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Range = ({
  rule,
  updateValue,
  editable
}) => {
  const minValid = rule.min <= rule.max;
  const maxValid = rule.max >= rule.min;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => updateValue(rule.min, rule.max, !rule.minInclusive, rule.maxInclusive)
    }, rule.minInclusive ? 'GTE' : 'GT'),
    placeholder: "min",
    value: rule.min,
    isInvalid: !minValid,
    disabled: !editable,
    onChange: e => updateValue(+e.currentTarget.value, rule.max, rule.minInclusive, rule.maxInclusive),
    "aria-label": "The min value"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    isInvalid: !maxValid,
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => updateValue(rule.min, rule.max, rule.minInclusive, !rule.maxInclusive)
    }, rule.maxInclusive ? 'LTE' : 'LT'),
    placeholder: "max",
    disabled: !editable,
    value: rule.max,
    onChange: e => updateValue(rule.min, +e.currentTarget.value, rule.minInclusive, rule.maxInclusive),
    "aria-label": "The max value"
  })));
};
exports.Range = Range;