"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignment = Assignment;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _color_mapping = require("../../state/color_mapping");
var _range = require("./range");
var _match = require("./match");
var _color_swatch = require("../color_picker/color_swatch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Assignment({
  data,
  assignment,
  disableDelete,
  index,
  total,
  canPickColor,
  editable,
  palette,
  colorMode,
  getPaletteFn,
  isDarkMode,
  specialTokens,
  assignmentValuesCounter
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "flexStart",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "assignment",
    isDarkMode: isDarkMode,
    swatchShape: "square",
    canPickColor: canPickColor,
    colorMode: colorMode,
    assignmentColor: assignment.color,
    getPaletteFn: getPaletteFn,
    index: index,
    palette: palette,
    total: total,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateAssignmentColor)({
        assignmentIndex: index,
        color
      }));
    }
  })), assignment.rule.type === 'auto' || assignment.rule.type === 'matchExactly' || assignment.rule.type === 'matchExactlyCI' ? /*#__PURE__*/_react.default.createElement(_match.Match, {
    editable: editable,
    index: index,
    rule: assignment.rule,
    options: data.type === 'categories' ? data.categories : [],
    specialTokens: specialTokens,
    updateValue: values => {
      dispatch((0, _color_mapping.updateAssignmentRule)({
        assignmentIndex: index,
        rule: values.length === 0 ? {
          type: 'auto'
        } : {
          type: 'matchExactly',
          values
        }
      }));
    },
    assignmentValuesCounter: assignmentValuesCounter
  }) : assignment.rule.type === 'range' ? /*#__PURE__*/_react.default.createElement(_range.Range, {
    rule: assignment.rule,
    editable: editable,
    updateValue: (min, max, minInclusive, maxInclusive) => {
      const rule = {
        type: 'range',
        min,
        max,
        minInclusive,
        maxInclusive
      };
      dispatch((0, _color_mapping.updateAssignmentRule)({
        assignmentIndex: index,
        rule
      }));
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    size: "xs",
    disabled: disableDelete,
    onClick: () => dispatch((0, _color_mapping.removeAssignment)(index)),
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.assignments.deleteAssignmentButtonLabel', {
      defaultMessage: 'Delete this assignment'
    }),
    color: "danger",
    css: !disableDelete ? (0, _react2.css)`
                  color: ${_uiTheme.euiThemeVars.euiTextSubduedColor};
                  transition: ${_uiTheme.euiThemeVars.euiAnimSpeedFast} ease-in-out;
                  transition-property: color;
                  &:hover,
                  &:focus {
                    color: ${_uiTheme.euiThemeVars.euiColorDangerText};
                  }
                ` : undefined
  })));
}