"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const highlight = (0, _css.keyframes)`
    0% { background-color: ${euiTheme.colors.warning};}
    50% { background-color: ${euiTheme.colors.emptyShade};}
    75% { background-color: ${euiTheme.colors.warning};}
    100% { background-color: ${euiTheme.colors.emptyShade};}
  `;
  const gridStyle = (0, _css.css)`
    & .euiDataGrid__content {
      background: transparent;
    }
    & .euiDataGridHeaderCell__icon {
      display: none;
    }
    & .euiDataGrid__controls {
      border-bottom: none;
      margin-bottom: ${euiTheme.size.s};

      & .euiButtonEmpty {
        font-weight: ${euiTheme.font.weight.bold};
      }
    }
    & .euiDataGrid__leftControls {
      > .euiButtonEmpty:hover:not(:disabled),
      .euiButtonEmpty:focus {
        text-decoration: none;
        cursor: default;
      }
    }
    & .euiButtonIcon {
      color: ${euiTheme.colors.primary};
    }
    & .euiDataGridRowCell {
      font-size: ${euiTheme.size.m};
    }
    & .euiDataGridRowCell__actions > [data-test-subj='euiDataGridCellExpandButton'] {
      display: none;
    }
    & .euiDataGridRowCell__actions--overlay {
      padding: 0;
    }

    & .euiDataGridRowCell__contentWrapper {
      display: flex;
      align-items: center;
    }
    & .euiDataGridRowCell.euiDataGridRowCell--numeric {
      text-align: left;
    }
  `;
  const highlightStyle = (0, _css.css)`
    & [data-test-subj='dataGridColumnSortingButton'] .euiButtonEmpty__text {
      animation: ${highlight} 1s ease-out infinite;
      color: ${euiTheme.colors.darkestShade};
    }
  `;
  const groupBySelector = (0, _css.css)`
    width: 188px;
    display: inline-block;
    margin-left: 8px;
  `;
  return {
    highlightStyle,
    gridStyle,
    groupBySelector
  };
};
exports.useStyles = useStyles;