"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregationCount = void 0;
Object.defineProperty(exports, "getFilters", {
  enumerable: true,
  get: function () {
    return _get_filters.getFilters;
  }
});
exports.getSelectedRowStyle = exports.getFindingsPageSizeInfo = exports.getFindingsCountAggQuery = void 0;
var _get_filters = require("./get_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFindingsPageSizeInfo = ({
  currentPageSize,
  pageIndex,
  pageSize
}) => ({
  pageStart: pageIndex * pageSize + 1,
  pageEnd: pageIndex * pageSize + currentPageSize
});
exports.getFindingsPageSizeInfo = getFindingsPageSizeInfo;
const getFindingsCountAggQuery = () => ({
  count: {
    terms: {
      field: 'result.evaluation'
    }
  }
});
exports.getFindingsCountAggQuery = getFindingsCountAggQuery;
const getAggregationCount = buckets => {
  const passed = buckets.find(bucket => (bucket === null || bucket === void 0 ? void 0 : bucket.key) === 'passed');
  const failed = buckets.find(bucket => (bucket === null || bucket === void 0 ? void 0 : bucket.key) === 'failed');
  return {
    passed: (passed === null || passed === void 0 ? void 0 : passed.doc_count) || 0,
    failed: (failed === null || failed === void 0 ? void 0 : failed.doc_count) || 0
  };
};
exports.getAggregationCount = getAggregationCount;
const isSelectedRow = (row, selected) => row.resource.id === (selected === null || selected === void 0 ? void 0 : selected.resource.id) && row.rule.id === (selected === null || selected === void 0 ? void 0 : selected.rule.id);
const getSelectedRowStyle = (theme, row, selected) => ({
  background: isSelectedRow(row, selected) ? theme.colors.highlight : undefined
});
exports.getSelectedRowStyle = getSelectedRowStyle;