"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsByResourceContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/usage-collection-plugin/public");
var _findings_search_bar = require("../layout/findings_search_bar");
var TEST_SUBJECTS = _interopRequireWildcard(require("../test_subjects"));
var _use_page_slice = require("../../../common/hooks/use_page_slice");
var _use_findings_by_resource = require("./use_findings_by_resource");
var _findings_by_resource_table = require("./findings_by_resource_table");
var _utils = require("../utils/utils");
var _findings_layout = require("../layout/findings_layout");
var _findings_group_by_selector = require("../layout/findings_group_by_selector");
var _constants = require("../../../common/navigation/constants");
var _resource_findings_container = require("./resource_findings/resource_findings_container");
var _error_callout = require("../layout/error_callout");
var _findings_distribution_bar = require("../layout/findings_distribution_bar");
var _constants2 = require("../../../common/constants");
var _use_cloud_posture_table = require("../../../common/hooks/use_cloud_posture_table");
var _get_limit_properties = require("../../../common/utils/get_limit_properties");
var _utils2 = require("../../../common/hooks/use_cloud_posture_table/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  pageIndex: 0,
  sort: {
    field: 'compliance_score',
    direction: 'asc'
  }
});

/**
 * @deprecated: This component is deprecated and will be removed in the next release.
 */
const FindingsByResourceContainer = ({
  dataView
}) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: _constants.findingsNavigation.findings_by_resource.path,
  render: () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: _constants.findingsNavigation.findings_by_resource.id
  }, /*#__PURE__*/_react.default.createElement(LatestFindingsByResource, {
    dataView: dataView
  }))
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: _constants.findingsNavigation.resource_findings.path,
  render: () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: _constants.findingsNavigation.resource_findings.id
  }, /*#__PURE__*/_react.default.createElement(_resource_findings_container.ResourceFindings, {
    dataView: dataView
  }))
}));

/**
 * @deprecated: This component is deprecated and will be removed in the next release.
 */
exports.FindingsByResourceContainer = FindingsByResourceContainer;
const LatestFindingsByResource = ({
  dataView
}) => {
  var _findingsGroupByResou, _findingsGroupByResou2;
  const {
    queryError,
    query,
    pageSize,
    setTableOptions,
    urlQuery,
    setUrlQuery,
    onResetFilters
  } = (0, _use_cloud_posture_table.useCloudPostureTable)({
    dataView,
    defaultQuery: getDefaultQuery,
    paginationLocalStorageKey: _constants2.LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY
  });

  /**
   * Page ES query result
   */
  const findingsGroupByResource = (0, _use_findings_by_resource.useFindingsByResource)({
    sortDirection: urlQuery.sort.direction,
    query,
    enabled: !queryError
  });
  const error = findingsGroupByResource.error || queryError;
  const slicedPage = (0, _use_page_slice.usePageSlice)((_findingsGroupByResou = findingsGroupByResource.data) === null || _findingsGroupByResou === void 0 ? void 0 : _findingsGroupByResou.page, urlQuery.pageIndex, pageSize);
  const {
    isLastLimitedPage,
    limitedTotalItemCount
  } = (0, _get_limit_properties.useLimitProperties)({
    total: (_findingsGroupByResou2 = findingsGroupByResource.data) === null || _findingsGroupByResou2 === void 0 ? void 0 : _findingsGroupByResou2.total,
    pageIndex: urlQuery.pageIndex,
    pageSize
  });
  const handleDistributionClick = evaluation => {
    setUrlQuery({
      pageIndex: 0,
      filters: (0, _utils.getFilters)({
        filters: urlQuery.filters,
        dataView,
        field: 'result.evaluation',
        value: evaluation,
        negate: false
      })
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TEST_SUBJECTS.FINDINGS_BY_RESOURCE_CONTAINER
  }, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
    dataView: dataView,
    setQuery: newQuery => {
      setUrlQuery({
        ...newQuery,
        pageIndex: 0
      });
    },
    loading: findingsGroupByResource.isFetching
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), error && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error
  }), !error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, findingsGroupByResource.isSuccess && !!findingsGroupByResource.data.page.length && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.FindingsDistributionBar, {
    distributionOnClick: handleDistributionClick,
    type: _i18n.i18n.translate('xpack.csp.findings.findingsByResource.tableRowTypeLabel', {
      defaultMessage: 'Resources'
    }),
    passed: findingsGroupByResource.data.count.passed,
    failed: findingsGroupByResource.data.count.failed
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.CurrentPageOfTotal, {
    pageStart: urlQuery.pageIndex * pageSize + 1,
    pageEnd: urlQuery.pageIndex * pageSize + slicedPage.length,
    total: findingsGroupByResource.data.total,
    type: _i18n.i18n.translate('xpack.csp.findings.findingsByResource.tableRowTypeLabel', {
      defaultMessage: 'Resources'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 188,
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_findings_group_by_selector.FindingsGroupBySelector, {
    type: "resource"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_findings_by_resource_table.FindingsByResourceTable, {
    loading: findingsGroupByResource.isFetching,
    items: slicedPage,
    onResetFilters: onResetFilters,
    pagination: (0, _utils2.getPaginationTableParams)({
      pageSize,
      pageIndex: urlQuery.pageIndex,
      totalItemCount: limitedTotalItemCount
    }),
    setTableOptions: setTableOptions,
    sorting: {
      sort: {
        field: 'compliance_score',
        direction: urlQuery.sort.direction
      }
    },
    onAddFilter: (field, value, negate) => setUrlQuery({
      pageIndex: 0,
      filters: (0, _utils.getFilters)({
        filters: urlQuery.filters,
        dataView,
        field,
        value,
        negate
      })
    })
  })), isLastLimitedPage && /*#__PURE__*/_react.default.createElement(_findings_layout.LimitedResultsBar, null));
};