"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ERROR_STATE_TEST_SUBJECT = exports.BenchmarksTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _timestamp_table_cell = require("../../components/timestamp_table_cell");
var _use_kibana = require("../../common/hooks/use_kibana");
var _constants = require("../../common/navigation/constants");
var TEST_SUBJ = _interopRequireWildcard(require("./test_subjects"));
var _get_enabled_csp_integration_details = require("../../common/utils/get_enabled_csp_integration_details");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _full_size_centered_page = require("../../components/full_size_centered_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_STATE_TEST_SUBJECT = 'benchmark_page_error';
exports.ERROR_STATE_TEST_SUBJECT = ERROR_STATE_TEST_SUBJECT;
const AgentPolicyButtonLink = ({
  name,
  id: policyId
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const [fleetBase, path] = _public.pagePathGetters.policy_details({
    policyId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend([fleetBase, path].join(''))
  }, name);
};
const IntegrationButtonLink = ({
  packageName,
  policyId,
  packagePolicyId
}) => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: application.getUrlForApp('security', {
      path: (0, _reactRouterDom.generatePath)(_constants.benchmarksNavigation.rules.path, {
        packagePolicyId,
        policyId
      })
    })
  }, packageName);
};
const ErrorMessageComponent = error => /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  color: "danger",
  iconType: "warning",
  "data-test-subj": ERROR_STATE_TEST_SUBJECT,
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.benchmarks.benchmarksTable.errorRenderer.errorTitle",
    defaultMessage: "We couldn't fetch your cloud security posture benchmark data"
  })),
  body: (0, _cloud_posture_page.isCommonError)(error) ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.benchmarks.benchmarksTable.errorRenderer.errorDescription",
    defaultMessage: "{error} {statusCode}: {body}",
    values: {
      error: error.body.error,
      statusCode: error.body.statusCode,
      body: error.body.message
    }
  })) : undefined
}));
const BENCHMARKS_TABLE_COLUMNS = [{
  field: 'package_policy.name',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.integrationNameColumnTitle', {
    defaultMessage: 'Integration Name'
  }),
  render: (packageName, benchmark) => /*#__PURE__*/_react.default.createElement(IntegrationButtonLink, {
    packageName: packageName,
    packagePolicyId: benchmark.package_policy.id,
    policyId: benchmark.package_policy.policy_id
  }),
  truncateText: true,
  sortable: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.INTEGRATION_NAME
}, {
  field: 'rules_count',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.rulesColumnTitle', {
    defaultMessage: 'Rules'
  }),
  truncateText: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.RULES
}, {
  field: 'package_policy',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.integrationColumnTitle', {
    defaultMessage: 'Integration'
  }),
  dataType: 'string',
  truncateText: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.INTEGRATION,
  render: field => {
    var _enabledIntegration$i;
    const enabledIntegration = (0, _get_enabled_csp_integration_details.getEnabledCspIntegrationDetails)(field);
    return (enabledIntegration === null || enabledIntegration === void 0 ? void 0 : (_enabledIntegration$i = enabledIntegration.integration) === null || _enabledIntegration$i === void 0 ? void 0 : _enabledIntegration$i.shortName) || ' ';
  }
}, {
  field: 'package_policy',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.monitoringColumnTitle', {
    defaultMessage: 'Monitoring'
  }),
  dataType: 'string',
  truncateText: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.MONITORING,
  render: field => {
    var _enabledIntegration$e;
    const enabledIntegration = (0, _get_enabled_csp_integration_details.getEnabledCspIntegrationDetails)(field);
    return (enabledIntegration === null || enabledIntegration === void 0 ? void 0 : (_enabledIntegration$e = enabledIntegration.enabledIntegrationOption) === null || _enabledIntegration$e === void 0 ? void 0 : _enabledIntegration$e.name) || ' ';
  }
}, {
  field: 'agent_policy.name',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.agentPolicyColumnTitle', {
    defaultMessage: 'Agent Policy'
  }),
  render: (name, benchmark) => /*#__PURE__*/_react.default.createElement(AgentPolicyButtonLink, {
    name: name,
    id: benchmark.agent_policy.id
  }),
  truncateText: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.AGENT_POLICY
}, {
  field: 'agent_policy.agents',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.numberOfAgentsColumnTitle', {
    defaultMessage: 'Number of Agents'
  }),
  truncateText: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.NUMBER_OF_AGENTS
}, {
  field: 'package_policy.created_by',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.createdByColumnTitle', {
    defaultMessage: 'Created by'
  }),
  dataType: 'string',
  truncateText: true,
  sortable: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.CREATED_BY,
  render: createdBy => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: createdBy,
      anchorClassName: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      size: "s",
      name: createdBy
    }), " ", createdBy));
  }
}, {
  field: 'package_policy.created_at',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.createdAtColumnTitle', {
    defaultMessage: 'Created'
  }),
  dataType: 'date',
  truncateText: true,
  render: timestamp => /*#__PURE__*/_react.default.createElement(_timestamp_table_cell.TimestampTableCell, {
    timestamp: timestamp
  }),
  sortable: true,
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.CREATED_AT
}];
const BenchmarksTable = ({
  benchmarks,
  pageIndex,
  pageSize,
  totalItemCount,
  loading,
  error,
  setQuery,
  noItemsMessage,
  sorting,
  ...rest
}) => {
  const pagination = {
    pageIndex: Math.max(pageIndex - 1, 0),
    pageSize,
    totalItemCount
  };
  const onChange = ({
    page,
    sort
  }) => {
    setQuery({
      page: {
        ...page,
        index: page.index + 1
      },
      sort
    });
  };
  if (error) {
    return /*#__PURE__*/_react.default.createElement(ErrorMessageComponent, {
      error: error
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": rest['data-test-subj'],
    items: benchmarks,
    columns: BENCHMARKS_TABLE_COLUMNS,
    itemId: item => [item.agent_policy.id, item.package_policy.id].join('/'),
    pagination: pagination,
    onChange: onChange,
    tableLayout: "fixed",
    loading: loading,
    noItemsMessage: noItemsMessage,
    error: error,
    sorting: sorting
  });
};
exports.BenchmarksTable = BenchmarksTable;