"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputVarsFields = exports.getGcpCredentialsType = exports.gcpField = exports.GcpCredentialsForm = exports.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
var _csp_boxed_radio_group = require("./csp_boxed_radio_group");
var _utils = require("./utils");
var _constants2 = require("../../common/constants");
var _constants3 = require("../../common/navigation/constants");
var _aws_credentials_form = require("./aws_credentials_form/aws_credentials_form");
var _policy_template_form = require("./policy_template_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS = {
  GOOGLE_CLOUD_SHELL_SETUP: 'google_cloud_shell_setup_test_id',
  PROJECT_ID: 'project_id_test_id',
  ORGANIZATION_ID: 'organization_id_test_id',
  CREDENTIALS_TYPE: 'credentials_type_test_id',
  CREDENTIALS_FILE: 'credentials_file_test_id',
  CREDENTIALS_JSON: 'credentials_json_test_id'
};
exports.CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS = CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS;
const GCPSetupInfoContent = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "xl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.gcpIntegration.setupInfoContentTitle",
  defaultMessage: "Setup Access"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.gcpIntegration.setupInfoContent",
  defaultMessage: "The integration will need elevated access to run some CIS benchmark rules. Select your preferred method of providing the GCP credentials this integration will use. You can follow these step-by-step instructions to generate the necessary credentials."
})));
const GoogleCloudShellSetup = ({
  fields,
  onChange,
  input,
  disabled
}) => {
  var _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$;
  const accountType = (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['gcp.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value;
  const getFieldById = id => {
    return fields.find(element => element.id === id);
  };
  const projectIdFields = getFieldById('gcp.project_id');
  const organizationIdFields = getFieldById('gcp.organization_id');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.GOOGLE_CLOUD_SHELL_SETUP
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: (0, _react2.css)`
            list-style: auto;
          `
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.hostRequirement",
    defaultMessage: "Ensure \"New hosts\" is selected in the \"Where to add this integration?\" section below"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.login",
    defaultMessage: "Log into your Google Cloud Console"
  })), accountType === _policy_template_form.GCP_ORGANIZATION_ACCOUNT ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.organizationCloudShellSetupStep.save",
    defaultMessage: "Note down the GCP organization ID of the organization you wish to monitor and project ID where you want to provision resources for monitoring purposes and provide them in the input boxes below"
  })) : /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.save",
    defaultMessage: "Note down the GCP project ID of the project you wish to monitor"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.gcpIntegration.cloudShellSetupStep.launch",
    defaultMessage: "Click \"Save and Continue\" at the bottom right of the page. Then, on the pop-up modal, click \"Launch Google Cloud Shell\""
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, organizationIdFields && accountType === _policy_template_form.GCP_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.organization_id'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.ORGANIZATION_ID,
    id: organizationIdFields.id,
    fullWidth: true,
    value: organizationIdFields.value || '',
    onChange: event => onChange(organizationIdFields.id, event.target.value)
  })), projectIdFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.project_id'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.PROJECT_ID,
    id: projectIdFields.id,
    fullWidth: true,
    value: projectIdFields.value || '',
    onChange: event => onChange(projectIdFields.id, event.target.value)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const credentialOptionsList = [{
  text: _i18n.i18n.translate('xpack.csp.gcpIntegration.credentialsFileOption', {
    defaultMessage: 'Credentials File'
  }),
  value: 'credentials-file',
  'data-test-subj': 'credentials_file_option_test_id'
}, {
  text: _i18n.i18n.translate('xpack.csp.gcpIntegration.credentialsJsonOption', {
    defaultMessage: 'Credentials JSON'
  }),
  value: 'credentials-json',
  'data-test-subj': 'credentials_json_option_test_id'
}];
const gcpField = {
  fields: {
    'gcp.organization_id': {
      label: _i18n.i18n.translate('xpack.csp.gcpIntegration.organizationIdFieldLabel', {
        defaultMessage: 'Organization ID'
      }),
      type: 'text'
    },
    'gcp.project_id': {
      label: _i18n.i18n.translate('xpack.csp.gcpIntegration.projectidFieldLabel', {
        defaultMessage: 'Project ID'
      }),
      type: 'text'
    },
    'gcp.credentials.file': {
      label: _i18n.i18n.translate('xpack.csp.findings.gcpIntegration.gcpInputText.credentialFileText', {
        defaultMessage: 'Path to JSON file containing the credentials and key used to subscribe'
      }),
      type: 'text'
    },
    'gcp.credentials.json': {
      label: _i18n.i18n.translate('xpack.csp.findings.gcpIntegration.gcpInputText.credentialJSONText', {
        defaultMessage: 'JSON blob containing the credentials and key used to subscribe'
      }),
      type: 'text'
    },
    'gcp.credentials.type': {
      label: _i18n.i18n.translate('xpack.csp.findings.gcpIntegration.gcpInputText.credentialSelectBoxTitle', {
        defaultMessage: 'Credential'
      }),
      type: 'text'
    }
  }
};
exports.gcpField = gcpField;
const getSetupFormatOptions = () => [{
  id: _constants.SETUP_ACCESS_CLOUD_SHELL,
  label: _i18n.i18n.translate('xpack.csp.gcpIntegration.setupFormatOptions.googleCloudShell', {
    defaultMessage: 'Google Cloud Shell'
  }),
  disabled: false,
  testId: 'gcpGoogleCloudShellOptionTestId'
}, {
  id: _constants.SETUP_ACCESS_MANUAL,
  label: _i18n.i18n.translate('xpack.csp.gcpIntegration.setupFormatOptions.manual', {
    defaultMessage: 'Manual'
  }),
  disabled: false,
  testId: 'gcpManualOptionTestId'
}];
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    value: inputVar.value
  };
});
exports.getInputVarsFields = getInputVarsFields;
const getSetupFormatFromInput = input => {
  var _input$streams$0$vars, _input$streams$0$vars2;
  const credentialsType = (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams$0$vars.setup_access) === null || _input$streams$0$vars2 === void 0 ? void 0 : _input$streams$0$vars2.value;
  // Google Cloud shell is the default value
  if (!credentialsType) {
    return _constants.SETUP_ACCESS_CLOUD_SHELL;
  }
  if (credentialsType !== _constants.SETUP_ACCESS_CLOUD_SHELL) {
    return _constants.SETUP_ACCESS_MANUAL;
  }
  return _constants.SETUP_ACCESS_CLOUD_SHELL;
};
const getGoogleCloudShellUrl = newPolicy => {
  var _newPolicy$inputs, _newPolicy$inputs$fin, _newPolicy$inputs$fin2, _newPolicy$inputs$fin3;
  const template = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$fin = _newPolicy$inputs.find(i => i.type === _constants.CLOUDBEAT_GCP)) === null || _newPolicy$inputs$fin === void 0 ? void 0 : (_newPolicy$inputs$fin2 = _newPolicy$inputs$fin.config) === null || _newPolicy$inputs$fin2 === void 0 ? void 0 : (_newPolicy$inputs$fin3 = _newPolicy$inputs$fin2.cloud_shell_url) === null || _newPolicy$inputs$fin3 === void 0 ? void 0 : _newPolicy$inputs$fin3.value;
  return template || undefined;
};
const updateCloudShellUrl = (newPolicy, updatePolicy, templateUrl) => {
  updatePolicy === null || updatePolicy === void 0 ? void 0 : updatePolicy({
    ...newPolicy,
    inputs: newPolicy.inputs.map(input => {
      if (input.type === _constants.CLOUDBEAT_GCP) {
        return {
          ...input,
          config: {
            cloud_shell_url: {
              value: templateUrl
            }
          }
        };
      }
      return input;
    })
  });
};
const useCloudShellUrl = ({
  packageInfo,
  newPolicy,
  updatePolicy,
  setupFormat
}) => {
  var _newPolicy$vars;
  (0, _react.useEffect)(() => {
    const policyInputCloudShellUrl = getGoogleCloudShellUrl(newPolicy);
    if (setupFormat === _constants.SETUP_ACCESS_MANUAL) {
      if (!!policyInputCloudShellUrl) {
        updateCloudShellUrl(newPolicy, updatePolicy, undefined);
      }
      return;
    }
    const templateUrl = (0, _utils.getCspmCloudShellDefaultValue)(packageInfo);

    // If the template is not available, do not update the policy
    if (templateUrl === '') return;

    // If the template is already set, do not update the policy
    if (policyInputCloudShellUrl === templateUrl) return;
    updateCloudShellUrl(newPolicy, updatePolicy, templateUrl);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$vars = newPolicy.vars) === null || _newPolicy$vars === void 0 ? void 0 : _newPolicy$vars.cloud_shell_url, newPolicy, packageInfo, setupFormat]);
};
const getGcpCredentialsType = input => {
  var _input$streams$0$vars3;
  return (_input$streams$0$vars3 = input.streams[0].vars) === null || _input$streams$0$vars3 === void 0 ? void 0 : _input$streams$0$vars3.setup_access.value;
};
exports.getGcpCredentialsType = getGcpCredentialsType;
const GcpCredentialsForm = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  setIsValid,
  onChange,
  disabled
}) => {
  var _input$streams2, _input$streams2$, _input$streams2$$vars, _input$streams2$$vars2;
  /* Create a subset of properties from GcpField to use for hiding value of credentials json and credentials file when user switch from Manual to Cloud Shell, we wanna keep Project and Organization ID */
  const subsetOfGcpField = (({
    ['gcp.credentials.file']: a,
    ['gcp.credentials.json']: b
  }) => ({
    'gcp.credentials.file': a,
    ['gcp.credentials.json']: b
  }))(gcpField.fields);
  const fieldsToHide = getInputVarsFields(input, subsetOfGcpField);
  const fields = getInputVarsFields(input, gcpField.fields);
  const validSemantic = (0, _valid.default)(packageInfo.version);
  const integrationVersionNumberOnly = (0, _coerce.default)(validSemantic) || '';
  const isInvalid = (0, _lt.default)(integrationVersionNumberOnly, _constants2.MIN_VERSION_GCP_CIS);
  const fieldsSnapshot = (0, _react.useRef)({});
  const lastSetupAccessType = (0, _react.useRef)(undefined);
  const setupFormat = getSetupFormatFromInput(input);
  const accountType = (_input$streams2 = input.streams) === null || _input$streams2 === void 0 ? void 0 : (_input$streams2$ = _input$streams2[0]) === null || _input$streams2$ === void 0 ? void 0 : (_input$streams2$$vars = _input$streams2$.vars) === null || _input$streams2$$vars === void 0 ? void 0 : (_input$streams2$$vars2 = _input$streams2$$vars['gcp.account_type']) === null || _input$streams2$$vars2 === void 0 ? void 0 : _input$streams2$$vars2.value;
  const isOrganization = accountType === 'organization-account';
  // Integration is Invalid IF Version is not at least 1.5.0 OR Setup Access is manual but Project ID is empty
  (0, _react.useEffect)(() => {
    const isInvalidPolicy = isInvalid;
    setIsValid(!isInvalidPolicy);
    onChange({
      isValid: !isInvalidPolicy,
      updatedPolicy: newPolicy
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [setupFormat, input.type]);
  useCloudShellUrl({
    packageInfo,
    newPolicy,
    updatePolicy,
    setupFormat
  });
  const onSetupFormatChange = newSetupFormat => {
    if (newSetupFormat === 'google_cloud_shell') {
      // We need to store the current manual fields to restore them later
      fieldsSnapshot.current = Object.fromEntries(fieldsToHide.map(field => [field.id, {
        value: field.value
      }]));
      // We need to store the last manual credentials type to restore it later
      lastSetupAccessType.current = getGcpCredentialsType(input);
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        setup_access: {
          value: 'google_cloud_shell',
          type: 'text'
        },
        // Clearing fields from previous setup format to prevent exposing credentials
        // when switching from manual to cloud formation
        ...Object.fromEntries(fieldsToHide.map(field => [field.id, {
          value: undefined
        }]))
      }));
    } else {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        setup_access: {
          // Restoring last manual credentials type
          value: lastSetupAccessType.current || _constants.SETUP_ACCESS_MANUAL,
          type: 'text'
        },
        // Restoring fields from manual setup format if any
        ...fieldsSnapshot.current
      }));
    }
  };
  if (isInvalid) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.gcpIntegration.gcpNotSupportedMessage",
      defaultMessage: "CIS GCP is not supported on the current Integration version, please upgrade your integration to the latest version to use CIS GCP"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(GCPSetupInfoContent, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    size: "s",
    options: getSetupFormatOptions(),
    idSelected: setupFormat,
    onChange: idSelected => idSelected !== setupFormat && onSetupFormatChange(idSelected)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), setupFormat === _constants.SETUP_ACCESS_CLOUD_SHELL ? /*#__PURE__*/_react.default.createElement(GoogleCloudShellSetup, {
    disabled: disabled,
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    })),
    input: input
  }) : /*#__PURE__*/_react.default.createElement(GcpInputVarFields, {
    disabled: disabled,
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    })),
    isOrganization: isOrganization
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: _constants3.cspIntegrationDocsNavigation.cspm.getStartedPath
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.GcpCredentialsForm = GcpCredentialsForm;
const GcpInputVarFields = ({
  fields,
  onChange,
  isOrganization,
  disabled
}) => {
  const getFieldById = id => {
    return fields.find(element => element.id === id);
  };
  const organizationIdFields = getFieldById('gcp.organization_id');
  const projectIdFields = getFieldById('gcp.project_id');
  const credentialsTypeFields = getFieldById('gcp.credentials.type');
  const credentialFilesFields = getFieldById('gcp.credentials.file');
  const credentialJSONFields = getFieldById('gcp.credentials.json');
  const credentialFieldValue = credentialOptionsList[0].value;
  const credentialJSONValue = credentialOptionsList[1].value;
  const credentialsTypeValue = (credentialsTypeFields === null || credentialsTypeFields === void 0 ? void 0 : credentialsTypeFields.value) || credentialOptionsList[0].value;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, organizationIdFields && isOrganization && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.organization_id'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.ORGANIZATION_ID,
    id: organizationIdFields.id,
    fullWidth: true,
    value: organizationIdFields.value || '',
    onChange: event => onChange(organizationIdFields.id, event.target.value)
  })), projectIdFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.project_id'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.PROJECT_ID,
    id: projectIdFields.id,
    fullWidth: true,
    value: projectIdFields.value || '',
    onChange: event => onChange(projectIdFields.id, event.target.value)
  })), credentialsTypeFields && credentialFilesFields && credentialJSONFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.credentials.type'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.CREDENTIALS_TYPE,
    fullWidth: true,
    options: credentialOptionsList,
    value: (credentialsTypeFields === null || credentialsTypeFields === void 0 ? void 0 : credentialsTypeFields.value) || credentialOptionsList[0].value,
    onChange: optionElem => {
      onChange(credentialsTypeFields === null || credentialsTypeFields === void 0 ? void 0 : credentialsTypeFields.id, optionElem.target.value);
    }
  })), credentialsTypeValue === credentialFieldValue && credentialFilesFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.credentials.file'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.CREDENTIALS_FILE,
    id: credentialFilesFields.id,
    fullWidth: true,
    value: credentialFilesFields.value || '',
    onChange: event => onChange(credentialFilesFields.id, event.target.value)
  })), credentialsTypeValue === credentialJSONValue && credentialJSONFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: gcpField.fields['gcp.credentials.json'].label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": CIS_GCP_INPUT_FIELDS_TEST_SUBJECTS.CREDENTIALS_JSON,
    id: credentialJSONFields.id,
    fullWidth: true,
    value: credentialJSONFields.value || '',
    onChange: event => onChange(credentialJSONFields.id, event.target.value)
  }))));
};