"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureCredentialsForm = exports.AZURE_MANUAL_CREDENTIAL_TYPE = exports.AZURE_ARM_TEMPLATE_CREDENTIAL_TYPE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _get_azure_credentials_form_options = require("./get_azure_credentials_form_options");
var _hooks = require("./hooks");
var _utils = require("../utils");
var _csp_boxed_radio_group = require("../csp_boxed_radio_group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AZURE_ARM_TEMPLATE_CREDENTIAL_TYPE = 'arm_template';
exports.AZURE_ARM_TEMPLATE_CREDENTIAL_TYPE = AZURE_ARM_TEMPLATE_CREDENTIAL_TYPE;
const AZURE_MANUAL_CREDENTIAL_TYPE = 'manual';
exports.AZURE_MANUAL_CREDENTIAL_TYPE = AZURE_MANUAL_CREDENTIAL_TYPE;
const AzureSetupInfoContent = ({
  integrationLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.setupInfoContentTitle",
    defaultMessage: "Setup Access"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.gettingStarted.setupInfoContent",
    defaultMessage: "Utilize an Azure Resource Manager (ARM) template (a built-in Azure IaC tool) or a series of manual steps to set up and deploy CSPM for assessing your Azure environment's security posture. Refer to our {gettingStartedLink} for details.",
    values: {
      gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: integrationLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.azureIntegration.gettingStarted.setupInfoContentLink",
        defaultMessage: "Getting Started guide"
      }))
    }
  })));
};
const getSetupFormatOptions = () => [{
  id: AZURE_ARM_TEMPLATE_CREDENTIAL_TYPE,
  label: 'ARM Template'
}, {
  id: AZURE_MANUAL_CREDENTIAL_TYPE,
  label: _i18n.i18n.translate('xpack.csp.azureIntegration.setupFormatOptions.manual', {
    defaultMessage: 'Manual'
  })
}];
const ARM_TEMPLATE_EXTERNAL_DOC_URL = 'https://learn.microsoft.com/en-us/azure/azure-resource-manager/templates/';
const ArmTemplateSetup = ({
  hasArmTemplateUrl,
  input
}) => {
  if (!hasArmTemplateUrl) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.azureIntegration.armTemplateSetupStep.notSupported",
      defaultMessage: "ARM Template is not supported on the current Integration version, please upgrade your integration to the latest version to use ARM Template"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: (0, _react2.css)`
            list-style: auto;
          `
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.armTemplateSetupStep.hostRequirement",
    defaultMessage: "Ensure \"New hosts\" is selected in the \"Where to add this integration?\" section below"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.armTemplateSetupStep.login",
    defaultMessage: "Log in to your Azure portal."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.armTemplateSetupStep.save",
    defaultMessage: "Click the Save and continue button on the bottom right of this page."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.armTemplateSetupStep.launch",
    defaultMessage: "On the subsequent pop-up modal, copy the relevant Bash command, then click on the Launch ARM Template button."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.armTemplateSetupNote",
    defaultMessage: "Read the {documentation} for more details",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ARM_TEMPLATE_EXTERNAL_DOC_URL,
        target: "_blank",
        rel: "noopener nofollow noreferrer",
        "data-test-subj": "externalLink"
      }, _i18n.i18n.translate('xpack.csp.azureIntegration.documentationLinkText', {
        defaultMessage: 'documentation'
      }))
    }
  })));
};
const AzureCredentialTypeSelector = ({
  type,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  fullWidth: true,
  label: _i18n.i18n.translate('xpack.csp.azureIntegration.azureCredentialTypeSelectorLabel', {
    defaultMessage: 'Preferred manual method'
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  fullWidth: true,
  options: (0, _get_azure_credentials_form_options.getAzureCredentialsFormManualOptions)(),
  value: type,
  onChange: optionElem => {
    onChange(optionElem.target.value);
  }
}));
const TemporaryManualSetup = ({
  integrationLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.manualCredentialType.instructions",
    defaultMessage: "Ensure the agent is deployed on a resource that supports managed identities (e.g., Azure Virtual Machines). No explicit credentials need to be provided; Azure handles the authentication. Refer to our {gettingStartedLink} for details.",
    values: {
      gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: integrationLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.azureIntegration.gettingStarted.setupInfoContentLink",
        defaultMessage: "Getting Started guide"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.manualCredentialType.documentaion",
    defaultMessage: "Read the {documentation} for more details",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ARM_TEMPLATE_EXTERNAL_DOC_URL,
        target: "_blank",
        rel: "noopener nofollow noreferrer",
        "data-test-subj": "externalLink"
      }, _i18n.i18n.translate('xpack.csp.azureIntegration.documentationLinkText', {
        defaultMessage: 'documentation'
      }))
    }
  })));
};
const AZURE_MINIMUM_PACKAGE_VERSION = '1.6.0';
const AZURE_MANUAL_FIELDS_PACKAGE_VERSION = '1.7.0';
const AzureInputVarFields = ({
  fields,
  onChange
}) => /*#__PURE__*/_react.default.createElement("div", null, fields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  key: field.id,
  label: field.label,
  fullWidth: true,
  hasChildLabel: true,
  id: field.id
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, field.type === 'password' && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
  id: field.id,
  type: "dual",
  fullWidth: true,
  value: field.value || '',
  onChange: event => onChange(field.id, event.target.value)
}), field.type === 'text' && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  id: field.id,
  fullWidth: true,
  value: field.value || '',
  onChange: event => onChange(field.id, event.target.value)
})))));
const AzureCredentialsForm = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  onChange,
  setIsValid,
  disabled
}) => {
  const {
    group,
    fields,
    azureCredentialsType,
    setupFormat,
    onSetupFormatChange,
    integrationLink,
    hasArmTemplateUrl
  } = (0, _hooks.useAzureCredentialsForm)({
    newPolicy,
    input,
    packageInfo,
    onChange,
    setIsValid,
    updatePolicy
  });
  (0, _react.useEffect)(() => {
    if (!setupFormat) {
      onSetupFormatChange(AZURE_ARM_TEMPLATE_CREDENTIAL_TYPE);
    }
  }, [setupFormat, onSetupFormatChange]);
  const packageSemanticVersion = (0, _valid.default)(packageInfo.version);
  const cleanPackageVersion = (0, _coerce.default)(packageSemanticVersion) || '';
  const isPackageVersionValidForAzure = !(0, _lt.default)(cleanPackageVersion, AZURE_MINIMUM_PACKAGE_VERSION);
  const isPackageVersionValidForManualFields = !(0, _lt.default)(cleanPackageVersion, AZURE_MANUAL_FIELDS_PACKAGE_VERSION);
  (0, _react.useEffect)(() => {
    setIsValid(isPackageVersionValidForAzure);
    onChange({
      isValid: isPackageVersionValidForAzure,
      updatedPolicy: newPolicy
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input, packageInfo, setupFormat]);
  if (!isPackageVersionValidForAzure) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.azureIntegration.azureNotSupportedMessage",
      defaultMessage: "CIS Azure is not supported on the current Integration version, please upgrade your integration to the latest version to use CIS Azure"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AzureSetupInfoContent, {
    integrationLink: integrationLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    size: "m",
    options: getSetupFormatOptions(),
    idSelected: setupFormat,
    onChange: idSelected => idSelected !== setupFormat && onSetupFormatChange(idSelected)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), setupFormat === AZURE_ARM_TEMPLATE_CREDENTIAL_TYPE && /*#__PURE__*/_react.default.createElement(ArmTemplateSetup, {
    hasArmTemplateUrl: hasArmTemplateUrl,
    input: input
  }), setupFormat === AZURE_MANUAL_CREDENTIAL_TYPE && !isPackageVersionValidForManualFields && /*#__PURE__*/_react.default.createElement(TemporaryManualSetup, {
    integrationLink: integrationLink
  }), setupFormat === AZURE_MANUAL_CREDENTIAL_TYPE && isPackageVersionValidForManualFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AzureCredentialTypeSelector, {
    type: azureCredentialsType,
    onChange: optionId => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'azure.credentials.type': {
          value: optionId
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(AzureInputVarFields, {
    fields: fields,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.manualCredentialType.documentaion",
    defaultMessage: "Read the {documentation} for more details",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ARM_TEMPLATE_EXTERNAL_DOC_URL,
        target: "_blank",
        rel: "noopener nofollow noreferrer",
        "data-test-subj": "externalLink"
      }, _i18n.i18n.translate('xpack.csp.azureIntegration.documentationLinkText', {
        defaultMessage: 'documentation'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AzureCredentialsForm = AzureCredentialsForm;