"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const gridContainer = (0, _css.css)`
    min-height: 400px;
  `;
  const gridStyle = (0, _css.css)`
    & .euiDataGridHeaderCell__icon {
      display: none;
    }
    & .euiDataGrid__controls {
      border-bottom: none;
      margin-bottom: ${euiTheme.size.s};
      border-top: none;
    }
    & .euiDataGrid--headerUnderline .euiDataGridHeaderCell {
      border-bottom: ${euiTheme.border.width.thick} solid ${euiTheme.colors.fullShade};
    }
    & .euiDataGridRowCell__contentByHeight + .euiDataGridRowCell__expandActions {
      padding: 0;
    }
    & .euiButtonIcon[data-test-subj='docTableExpandToggleColumn'] {
      color: ${euiTheme.colors.primary};
    }

    & .euiDataGridRowCell {
      font-size: ${euiTheme.size.m};
    }
    & .euiDataGridRowCell__expandFlex {
      align-items: center;
    }
    & .euiDataGridRowCell.euiDataGridRowCell--numeric {
      text-align: left;
    }
    & .euiDataGrid__controls {
      gap: ${euiTheme.size.s};
    }
    & .euiDataGrid__leftControls {
      display: flex;
      align-items: center;
      width: 100%;
    }
    & .cspDataTableTotal {
      font-size: ${euiTheme.size.m};
      font-weight: ${euiTheme.font.weight.bold};
      border-right: ${euiTheme.border.thin};
      margin-right: ${euiTheme.size.s};
      padding-right: ${euiTheme.size.m};
    }
    & .euiDataGrid__rightControls {
      display: none;
    }

    & [data-test-subj='docTableExpandToggleColumn'] svg {
      inline-size: 16px;
      block-size: 16px;
    }

    & .unifiedDataTable__cellValue {
      font-family: ${euiTheme.font.family};
    }
  `;
  const groupBySelector = (0, _css.css)`
    margin-left: auto;
  `;
  return {
    gridStyle,
    groupBySelector,
    gridContainer
  };
};
exports.useStyles = useStyles;