"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findCspRuleTemplateRequest = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// this pages follows versioning interface strategy https://docs.elastic.dev/kibana-dev-docs/versioning-interfaces

const DEFAULT_RULES_TEMPLATE_PER_PAGE = 25;
const findCspRuleTemplateRequest = _configSchema.schema.object({
  /**
   * An Elasticsearch simple_query_string
   */
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  /**
   * The page of objects to return
   */
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  /**
   * The number of objects to include in each page
   */
  perPage: _configSchema.schema.number({
    defaultValue: DEFAULT_RULES_TEMPLATE_PER_PAGE,
    min: 0
  }),
  /**
   *  Fields to retrieve from CspRuleTemplate saved object
   */
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  /**
   *  The fields to perform the parsed query against.
   * Valid fields are fields which mapped to 'text' in cspRuleTemplateSavedObjectMapping
   */
  searchFields: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('metadata.name.text'), _configSchema.schema.literal('metadata.section.text')]), {
    defaultValue: ['metadata.name.text']
  }),
  /**
   *  Sort Field
   */
  sortField: _configSchema.schema.oneOf([_configSchema.schema.literal('metadata.name'), _configSchema.schema.literal('metadata.section'), _configSchema.schema.literal('metadata.id'), _configSchema.schema.literal('metadata.version'), _configSchema.schema.literal('metadata.benchmark.id'), _configSchema.schema.literal('metadata.benchmark.name'), _configSchema.schema.literal('metadata.benchmark.posture_type'), _configSchema.schema.literal('metadata.benchmark.version'), _configSchema.schema.literal('metadata.benchmark.rule_number')], {
    defaultValue: 'metadata.benchmark.rule_number'
  }),
  /**
   * The order to sort by
   */
  sortOrder: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
    defaultValue: 'asc'
  }),
  /**
   * benchmark id
   */
  benchmarkId: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('cis_k8s'), _configSchema.schema.literal('cis_eks'), _configSchema.schema.literal('cis_aws')])),
  /**
   * package_policy_id
   */
  packagePolicyId: _configSchema.schema.maybe(_configSchema.schema.string()),
  /**
   * rule section
   */
  section: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.findCspRuleTemplateRequest = findCspRuleTemplateRequest;