"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Warnings = Warnings;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Warnings({
  warnings,
  compressed = false,
  'data-test-subj': dataTestSubj = 'chart-inline-warning-button'
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [open, setOpen] = (0, _react2.useState)(false);
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const onWarningButtonClick = (0, _react2.useCallback)(() => {
    setOpen(!open);
  }, [open]);
  if (warnings.length === 0) return null;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    isOpen: open,
    panelPaddingSize: "none",
    closePopover: () => setOpen(false),
    button: compressed ? /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      color: "warning",
      css: (0, _react.css)`
                block-size: ${euiTheme.size.l};
                border-radius: 0 ${euiTheme.border.radius.medium} 0 ${euiTheme.border.radius.small};
                font-size: ${xsFontSize};
                padding: 0 ${euiTheme.size.xs};
                & > * {
                  gap: ${euiTheme.size.xs};
                }
              `,
      iconSize: "s",
      iconType: "warning",
      minWidth: 0,
      onClick: onWarningButtonClick,
      size: "s",
      "data-test-subj": dataTestSubj
    }, warnings.length) : /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      color: "warning",
      iconType: "warning",
      onClick: onWarningButtonClick,
      size: "xs",
      "data-test-subj": dataTestSubj
    }, _i18n.i18n.translate('charts.warning.warningLabel', {
      defaultMessage: '{numberWarnings, number} {numberWarnings, plural, one {warning} other {warnings}}',
      values: {
        numberWarnings: warnings.length
      }
    }))
  }, /*#__PURE__*/_react2.default.createElement("div", {
    style: {
      maxWidth: 512
    }
  }, warnings.map((w, i) => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, {
    key: i
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: {
      padding: euiTheme.size.s
    },
    "data-test-subj": "chart-inline-warning"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, w)), i < warnings.length - 1 && /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }))))));
}