"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemeService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _rxjs = require("rxjs");
var _charts = require("@elastic/charts");
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ThemeService {
  constructor() {
    /** Returns default charts theme */
    (0, _defineProperty2.default)(this, "chartsDefaultTheme", _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme);
    (0, _defineProperty2.default)(this, "chartsDefaultBaseTheme", _charts.LIGHT_THEME);
    (0, _defineProperty2.default)(this, "theme$", void 0);
    (0, _defineProperty2.default)(this, "_chartsTheme$", new _rxjs.BehaviorSubject(this.chartsDefaultTheme));
    (0, _defineProperty2.default)(this, "_chartsBaseTheme$", new _rxjs.BehaviorSubject(this.chartsDefaultBaseTheme));
    /** An observable of the current charts theme */
    (0, _defineProperty2.default)(this, "chartsTheme$", this._chartsTheme$.asObservable());
    /** An observable of the current charts base theme */
    (0, _defineProperty2.default)(this, "chartsBaseTheme$", this._chartsBaseTheme$.asObservable());
    /** A React hook for consuming the dark mode value */
    (0, _defineProperty2.default)(this, "useDarkMode", () => {
      const [value, update] = (0, _react.useState)(false);
      (0, _react.useEffect)(() => {
        const s = this.darkModeEnabled$.subscribe(val => {
          update(val.darkMode);
        });
        return () => s.unsubscribe();
      }, []);
      return value;
    });
    /** A React hook for consuming the charts theme */
    (0, _defineProperty2.default)(this, "useChartsTheme", () => {
      const [value, update] = (0, _react.useState)(this._chartsTheme$.getValue());
      const ref = (0, _react.useRef)(value);
      (0, _react.useEffect)(() => {
        const s = this.chartsTheme$.subscribe(val => {
          if (val !== ref.current) {
            ref.current = val;
            update(val);
          }
        });
        return () => s.unsubscribe();
      }, []);
      return value;
    });
    /** A React hook for consuming the charts theme */
    (0, _defineProperty2.default)(this, "useChartsBaseTheme", () => {
      const [value, update] = (0, _react.useState)(this._chartsBaseTheme$.getValue());
      const ref = (0, _react.useRef)(value);
      (0, _react.useEffect)(() => {
        const s = this.chartsBaseTheme$.subscribe(val => {
          if (val !== ref.current) {
            ref.current = val;
            update(val);
          }
        });
        return () => s.unsubscribe();
      }, []);
      return value;
    });
  }
  /** An observable boolean for dark mode of kibana */
  get darkModeEnabled$() {
    if (!this.theme$) {
      throw new Error('ThemeService not initialized');
    }
    return this.theme$;
  }
  /** initialize service with uiSettings */
  init(theme) {
    this.theme$ = theme.theme$;
    this.theme$.subscribe(({
      darkMode
    }) => {
      const selectedTheme = darkMode ? _eui_charts_theme.EUI_CHARTS_THEME_DARK.theme : _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme;
      this._chartsTheme$.next(selectedTheme);
      this._chartsBaseTheme$.next(darkMode ? _charts.DARK_THEME : _charts.LIGHT_THEME);
    });
  }
}
exports.ThemeService = ThemeService;