"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLastPageUserActions = void 0;
var _react = require("react");
var _use_find_case_user_actions = require("../../containers/use_find_case_user_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLastPageUserActions = ({
  userActivityQueryParams,
  caseId,
  lastPage
}) => {
  const {
    data: lastPageUserActionsData,
    isLoading: isLoadingLastPageUserActions
  } = (0, _use_find_case_user_actions.useFindCaseUserActions)(caseId, {
    ...userActivityQueryParams,
    page: lastPage
  }, lastPage > 1);
  const lastPageUserActions = (0, _react.useMemo)(() => {
    if (isLoadingLastPageUserActions || !lastPageUserActionsData) {
      return [];
    }
    return lastPageUserActionsData.userActions;
  }, [lastPageUserActionsData, isLoadingLastPageUserActions]);
  return {
    isLoadingLastPageUserActions,
    lastPageUserActions
  };
};
exports.useLastPageUserActions = useLastPageUserActions;