"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ALREADY_PUSHED_TO_SERVICE: true,
  REQUIRED_UPDATE_TO_SERVICE: true,
  COPY_REFERENCE_LINK: true,
  MOVE_TO_ORIGINAL_COMMENT: true,
  ALERT_COMMENT_LABEL_TITLE: true,
  MULTIPLE_ALERTS_COMMENT_LABEL_TITLE: true,
  SHOW_ALERT_TOOLTIP: true,
  SHOW_ALERT_TABLE_TOOLTIP: true,
  UNKNOWN_RULE: true,
  ISOLATED_HOST: true,
  RELEASED_HOST: true,
  OTHER_ENDPOINTS: true,
  CANCEL_BUTTON: true,
  DELETE: true,
  ASSIGNED: true,
  UNASSIGNED: true,
  THEMSELVES: true,
  AND: true,
  UNSAVED_DRAFT_DESCRIPTION: true,
  SHOW_MORE: true,
  CREATE_CASE: true
};
exports.UNSAVED_DRAFT_DESCRIPTION = exports.UNKNOWN_RULE = exports.UNASSIGNED = exports.THEMSELVES = exports.SHOW_MORE = exports.SHOW_ALERT_TOOLTIP = exports.SHOW_ALERT_TABLE_TOOLTIP = exports.REQUIRED_UPDATE_TO_SERVICE = exports.RELEASED_HOST = exports.OTHER_ENDPOINTS = exports.MULTIPLE_ALERTS_COMMENT_LABEL_TITLE = exports.MOVE_TO_ORIGINAL_COMMENT = exports.ISOLATED_HOST = exports.DELETE = exports.CREATE_CASE = exports.COPY_REFERENCE_LINK = exports.CANCEL_BUTTON = exports.ASSIGNED = exports.AND = exports.ALREADY_PUSHED_TO_SERVICE = exports.ALERT_COMMENT_LABEL_TITLE = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../case_view/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALREADY_PUSHED_TO_SERVICE = externalService => _i18n.i18n.translate('xpack.cases.caseView.alreadyPushedToExternalService', {
  values: {
    externalService
  },
  defaultMessage: 'Already pushed to { externalService } incident'
});
exports.ALREADY_PUSHED_TO_SERVICE = ALREADY_PUSHED_TO_SERVICE;
const REQUIRED_UPDATE_TO_SERVICE = externalService => _i18n.i18n.translate('xpack.cases.caseView.requiredUpdateToExternalService', {
  values: {
    externalService
  },
  defaultMessage: 'Requires update to { externalService } incident'
});
exports.REQUIRED_UPDATE_TO_SERVICE = REQUIRED_UPDATE_TO_SERVICE;
const COPY_REFERENCE_LINK = _i18n.i18n.translate('xpack.cases.caseView.copyCommentLinkAria', {
  defaultMessage: 'Copy reference link'
});
exports.COPY_REFERENCE_LINK = COPY_REFERENCE_LINK;
const MOVE_TO_ORIGINAL_COMMENT = _i18n.i18n.translate('xpack.cases.caseView.moveToCommentAria', {
  defaultMessage: 'Highlight the referenced comment'
});
exports.MOVE_TO_ORIGINAL_COMMENT = MOVE_TO_ORIGINAL_COMMENT;
const ALERT_COMMENT_LABEL_TITLE = _i18n.i18n.translate('xpack.cases.caseView.alertCommentLabelTitle', {
  defaultMessage: 'added an alert from'
});
exports.ALERT_COMMENT_LABEL_TITLE = ALERT_COMMENT_LABEL_TITLE;
const MULTIPLE_ALERTS_COMMENT_LABEL_TITLE = totalAlerts => _i18n.i18n.translate('xpack.cases.caseView.generatedAlertCommentLabelTitle', {
  values: {
    totalAlerts
  },
  defaultMessage: 'added {totalAlerts} alerts from'
});
exports.MULTIPLE_ALERTS_COMMENT_LABEL_TITLE = MULTIPLE_ALERTS_COMMENT_LABEL_TITLE;
const SHOW_ALERT_TOOLTIP = _i18n.i18n.translate('xpack.cases.caseView.showAlertTooltip', {
  defaultMessage: 'Show alert details'
});
exports.SHOW_ALERT_TOOLTIP = SHOW_ALERT_TOOLTIP;
const SHOW_ALERT_TABLE_TOOLTIP = _i18n.i18n.translate('xpack.cases.caseView.showAlertTableTooltip', {
  defaultMessage: 'Show alerts'
});
exports.SHOW_ALERT_TABLE_TOOLTIP = SHOW_ALERT_TABLE_TOOLTIP;
const UNKNOWN_RULE = _i18n.i18n.translate('xpack.cases.caseView.unknownRule.label', {
  defaultMessage: 'Unknown rule'
});
exports.UNKNOWN_RULE = UNKNOWN_RULE;
const ISOLATED_HOST = _i18n.i18n.translate('xpack.cases.caseView.isolatedHost', {
  defaultMessage: 'submitted isolate request on host'
});
exports.ISOLATED_HOST = ISOLATED_HOST;
const RELEASED_HOST = _i18n.i18n.translate('xpack.cases.caseView.releasedHost', {
  defaultMessage: 'submitted release request on host'
});
exports.RELEASED_HOST = RELEASED_HOST;
const OTHER_ENDPOINTS = endpoints => _i18n.i18n.translate('xpack.cases.caseView.otherEndpoints', {
  values: {
    endpoints
  },
  defaultMessage: ` and {endpoints} {endpoints, plural, =1 {other} other {others}}`
});
exports.OTHER_ENDPOINTS = OTHER_ENDPOINTS;
const CANCEL_BUTTON = _i18n.i18n.translate('xpack.cases.caseView.delete.cancel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL_BUTTON = CANCEL_BUTTON;
const DELETE = _i18n.i18n.translate('xpack.cases.caseView.delete.confirm', {
  defaultMessage: 'Delete'
});
exports.DELETE = DELETE;
const ASSIGNED = _i18n.i18n.translate('xpack.cases.caseView.assigned', {
  defaultMessage: 'assigned'
});
exports.ASSIGNED = ASSIGNED;
const UNASSIGNED = _i18n.i18n.translate('xpack.cases.caseView.unAssigned', {
  defaultMessage: 'unassigned'
});
exports.UNASSIGNED = UNASSIGNED;
const THEMSELVES = _i18n.i18n.translate('xpack.cases.caseView.assignee.themselves', {
  defaultMessage: 'themselves'
});
exports.THEMSELVES = THEMSELVES;
const AND = _i18n.i18n.translate('xpack.cases.caseView.assignee.and', {
  defaultMessage: 'and'
});
exports.AND = AND;
const UNSAVED_DRAFT_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.description.unsavedDraftDescription', {
  defaultMessage: 'You have unsaved edits for the description'
});
exports.UNSAVED_DRAFT_DESCRIPTION = UNSAVED_DRAFT_DESCRIPTION;
const SHOW_MORE = _i18n.i18n.translate('xpack.cases.caseView.userActions.showMore', {
  defaultMessage: 'Show more'
});
exports.SHOW_MORE = SHOW_MORE;
const CREATE_CASE = _i18n.i18n.translate('xpack.cases.caseView.userActions.createCase', {
  defaultMessage: 'Created case'
});
exports.CREATE_CASE = CREATE_CASE;