"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStatusUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _common = require("./common");
var _status2 = require("../status");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isStatusValid = status => Object.prototype.hasOwnProperty.call(_status2.statuses, status);
const getLabelTitle = userAction => {
  var _userAction$payload$s;
  const status = (_userAction$payload$s = userAction.payload.status) !== null && _userAction$payload$s !== void 0 ? _userAction$payload$s : '';
  if (isStatusValid(status)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": `${userAction.id}-user-action-status-title`,
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, i18n.MARKED_CASE_AS), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_status.Status, {
      status: status
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
const createStatusUserActionBuilder = ({
  userAction,
  userProfiles,
  handleOutlineComment
}) => ({
  build: () => {
    const statusUserAction = userAction;
    const label = getLabelTitle(statusUserAction);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userAction,
      userProfiles,
      handleOutlineComment,
      label,
      icon: 'folderClosed'
    });
    return commonBuilder.build();
  }
});
exports.createStatusUserActionBuilder = createStatusUserActionBuilder;