"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomFieldsUserActionBuilder = void 0;
var _common = require("../common");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLabelTitle = (customField, customFieldConfiguration) => {
  var _ref, _customFieldConfigura;
  const customFieldValue = customField.value;
  const label = (_ref = (_customFieldConfigura = customFieldConfiguration === null || customFieldConfiguration === void 0 ? void 0 : customFieldConfiguration.label) !== null && _customFieldConfigura !== void 0 ? _customFieldConfigura : customFieldConfiguration === null || customFieldConfiguration === void 0 ? void 0 : customFieldConfiguration.key) !== null && _ref !== void 0 ? _ref : i18n.UNKNOWN;
  if (customFieldValue == null || Array.isArray(customFieldValue) && customFieldValue.length === 0) {
    return i18n.CHANGED_FIELD_TO_EMPTY(label);
  }
  const value = Array.isArray(customFieldValue) ? customFieldValue[0] : customFieldValue;
  return `${i18n.CHANGED_FIELD.toLowerCase()} ${label} ${i18n.TO} "${value}"`;
};
const createCustomFieldsUserActionBuilder = ({
  userAction,
  handleOutlineComment,
  userProfiles,
  casesConfiguration
}) => ({
  build: () => {
    const customFieldsUserAction = userAction;
    if (customFieldsUserAction.payload.customFields.length === 0) {
      return [];
    }
    const customField = customFieldsUserAction.payload.customFields[0];
    const customFieldConfiguration = casesConfiguration.customFields.find(configCustomField => configCustomField.key === customField.key);
    const label = getLabelTitle(customField, customFieldConfiguration);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userAction,
      userProfiles,
      handleOutlineComment,
      label,
      icon: 'dot'
    });
    return commonBuilder.build();
  }
});
exports.createCustomFieldsUserActionBuilder = createCustomFieldsUserActionBuilder;