"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensDraftComment = void 0;
var _react = require("react");
var _operators = require("rxjs/operators");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("./constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensDraftComment = () => {
  const {
    application: {
      currentAppId$
    },
    embeddable,
    storage
  } = (0, _kibana.useKibana)().services;
  const [draftComment, setDraftComment] = (0, _react.useState)(null);
  const [hasIncomingLensState, setHasIncomingLensState] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const fetchDraftComment = async () => {
      const currentAppId = await currentAppId$.pipe((0, _operators.first)()).toPromise();
      if (!currentAppId) {
        return;
      }
      const incomingEmbeddablePackage = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getStateTransfer().getIncomingEmbeddablePackage(currentAppId);
      const storageDraftComment = storage.get(_constants.DRAFT_COMMENT_STORAGE_ID);
      setHasIncomingLensState(!!incomingEmbeddablePackage);
      if (storageDraftComment) {
        setDraftComment(storageDraftComment);
      }
    };
    fetchDraftComment();
  }, [currentAppId$, embeddable, storage]);
  const openLensModal = (0, _react.useCallback)(({
    editorRef
  }) => {
    if (editorRef && editorRef.textarea && editorRef.toolbar) {
      var _editorRef$toolbar;
      const lensPluginButton = (_editorRef$toolbar = editorRef.toolbar) === null || _editorRef$toolbar === void 0 ? void 0 : _editorRef$toolbar.querySelector(`[aria-label="${_translations.VISUALIZATION}"]`);
      if (lensPluginButton) {
        lensPluginButton.click();
      }
    }
  }, []);
  const clearDraftComment = (0, _react.useCallback)(() => {
    storage.remove(_constants.DRAFT_COMMENT_STORAGE_ID);
    setDraftComment(null);
  }, [storage]);
  return {
    draftComment,
    hasIncomingLensState,
    openLensModal,
    clearDraftComment
  };
};
exports.useLensDraftComment = useLensDraftComment;