"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  SAVE: true,
  CANCEL: true,
  EDIT_TITLE_ARIA: true,
  BETA_LABEL: true,
  BETA_DESC: true
};
exports.SAVE = exports.EDIT_TITLE_ARIA = exports.CANCEL = exports.BETA_LABEL = exports.BETA_DESC = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SAVE = _i18n.i18n.translate('xpack.cases.header.editableTitle.save', {
  defaultMessage: 'Save'
});
exports.SAVE = SAVE;
const CANCEL = _i18n.i18n.translate('xpack.cases.header.editableTitle.cancel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL = CANCEL;
const EDIT_TITLE_ARIA = title => _i18n.i18n.translate('xpack.cases.header.editableTitle.editButtonAria', {
  values: {
    title
  },
  defaultMessage: 'You can edit {title} by clicking'
});
exports.EDIT_TITLE_ARIA = EDIT_TITLE_ARIA;
const BETA_LABEL = _i18n.i18n.translate('xpack.cases.header.badge.betaLabel', {
  defaultMessage: 'Beta'
});
exports.BETA_LABEL = BETA_LABEL;
const BETA_DESC = _i18n.i18n.translate('xpack.cases.header.badge.betaDesc', {
  defaultMessage: 'This feature is currently in beta. If you encounter any bugs or have feedback, please open an issue or visit our discussion forum.'
});
exports.BETA_DESC = BETA_DESC;