"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleExperimentalBadge = exports.TitleBetaBadge = exports.Title = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _truncated_text = require("../truncated_text");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExperimentalBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: i18n.EXPERIMENTAL_LABEL,
  tooltipContent: i18n.EXPERIMENTAL_DESC,
  tooltipPosition: "bottom"
});
ExperimentalBadge.displayName = 'ExperimentalBadge';
const TitleExperimentalBadge = /*#__PURE__*/_react.default.memo(ExperimentalBadge);
exports.TitleExperimentalBadge = TitleExperimentalBadge;
const BetaBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: i18n.BETA_LABEL,
  tooltipContent: i18n.BETA_DESC,
  tooltipPosition: "bottom"
});
BetaBadge.displayName = 'BetaBadge';
const TitleBetaBadge = /*#__PURE__*/_react.default.memo(BetaBadge);
exports.TitleBetaBadge = TitleBetaBadge;
const TitleComponent = ({
  title,
  releasePhase,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "baseline",
  gutterSize: "s",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l"
}, /*#__PURE__*/_react.default.createElement("h1", {
  "data-test-subj": "header-page-title"
}, (0, _lodash.isString)(title) ? /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
  text: title
}) : title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, children))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, releasePhase === 'experimental' && /*#__PURE__*/_react.default.createElement(ExperimentalBadge, null), releasePhase === 'beta' && /*#__PURE__*/_react.default.createElement(BetaBadge, null)));
TitleComponent.displayName = 'Title';
const Title = /*#__PURE__*/_react.default.memo(TitleComponent);
exports.Title = Title;