"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _title = require("./title");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditableTitleComponent = ({
  onSubmit,
  isLoading,
  title
}) => {
  const {
    releasePhase,
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [editMode, setEditMode] = (0, _react.useState)(false);
  const [errors, setErrors] = (0, _react.useState)([]);
  const onClickSubmit = (0, _react.useCallback)(newTitleValue => {
    if (!newTitleValue.trim().length) {
      setErrors([i18n.TITLE_REQUIRED]);
      return false;
    }
    if (newTitleValue.trim().length > _constants.MAX_TITLE_LENGTH) {
      setErrors([i18n.MAX_LENGTH_ERROR('title', _constants.MAX_TITLE_LENGTH)]);
      return false;
    }
    if (newTitleValue !== title) {
      onSubmit(newTitleValue.trim());
    }
    setEditMode(false);
    setErrors([]);
    return true;
  }, [onSubmit, title]);
  const onCancel = () => {
    setErrors([]);
    setEditMode(false);
  };
  const hasErrors = errors.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: releasePhase && {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditTitle, {
    defaultValue: title,
    readModeProps: {
      onClick: () => setEditMode(true),
      'data-test-subj': 'editable-title-header-value'
    },
    editModeProps: {
      formRowProps: {
        error: errors
      },
      inputProps: {
        'data-test-subj': 'editable-title-input-field',
        onChange: () => {
          setErrors([]);
        }
      },
      saveButtonProps: {
        'data-test-subj': 'editable-title-submit-btn',
        isDisabled: hasErrors
      },
      cancelButtonProps: {
        onClick: () => onCancel(),
        'data-test-subj': 'editable-title-cancel-btn'
      }
    },
    inputAriaLabel: "Editable title input field",
    heading: "h1",
    size: "s",
    isInvalid: hasErrors,
    isLoading: isLoading,
    isReadOnly: !permissions.update,
    onSave: value => {
      return onClickSubmit(value);
    },
    startWithEditOpen: editMode,
    "data-test-subj": "header-page-title"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, releasePhase === 'experimental' && /*#__PURE__*/_react.default.createElement(_title.TitleExperimentalBadge, null), releasePhase === 'beta' && /*#__PURE__*/_react.default.createElement(_title.TitleBetaBadge, null)));
};
EditableTitleComponent.displayName = 'EditableTitle';
const EditableTitle = /*#__PURE__*/_react.default.memo(EditableTitleComponent);
exports.EditableTitle = EditableTitle;