"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileAttachmentEvent = void 0;
var _react = _interopRequireDefault(require("react"));
var _file_name_link = require("./file_name_link");
var _file_preview = require("./file_preview");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_file_preview = require("./use_file_preview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileAttachmentEvent = ({
  file
}) => {
  const {
    isPreviewVisible,
    showPreview,
    closePreview
  } = (0, _use_file_preview.useFilePreview)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ADDED, /*#__PURE__*/_react.default.createElement(_file_name_link.FileNameLink, {
    file: file,
    showPreview: showPreview
  }), isPreviewVisible && /*#__PURE__*/_react.default.createElement(_file_preview.FilePreview, {
    closePreview: closePreview,
    selectedFile: file
  }));
};
exports.FileAttachmentEvent = FileAttachmentEvent;
FileAttachmentEvent.displayName = 'FileAttachmentEvent';