"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExperimentalBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _translations = require("../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExperimentalBadgeComponent = ({
  icon = false,
  size = 's'
}) => {
  const props = {
    label: _translations.EXPERIMENTAL_LABEL,
    size,
    ...(icon && {
      iconType: 'beaker'
    }),
    tooltipContent: _translations.EXPERIMENTAL_DESC,
    tooltipPosition: 'bottom',
    'data-test-subj': 'case-experimental-badge'
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, (0, _extends2.default)({
    css: (0, _react2.css)`
        margin-left: 5px;
      `
  }, props));
};
ExperimentalBadgeComponent.displayName = 'ExperimentalBadge';
const ExperimentalBadge = /*#__PURE__*/_react.default.memo(ExperimentalBadgeComponent);
exports.ExperimentalBadge = ExperimentalBadge;